/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon.tree;

import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.calculator.CoordinateSequenceOrientationCalculator;
import net.anwiba.spatial.geometry.IGeometryFactoryProvider;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.internal.LinearRing;
import net.anwiba.spatial.geometry.polygon.ContainsLinearRingOperator;
import net.anwiba.spatial.geometry.polygon.tree.AbstractGeometryNode;
import net.anwiba.spatial.geometry.polygon.tree.IGeometryNode;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;

public class GeometryNode
extends AbstractGeometryNode
implements IGeometryNode {
    private final ILinearRing geometry;
    private IPolygon polygon;
    private ContainsLinearRingOperator operator;
    private final IGeometryFactoryProvider factoryProvider;

    public GeometryNode(IGeometryFactoryProvider factoryProvider, ILinearRing ring) {
        this.factoryProvider = factoryProvider;
        this.geometry = ring;
    }

    @Override
    public boolean contains(IGeometryNode node) {
        IPolygon ownPolygon = this.asPolygon();
        IPolygon nodePolygon = node.asPolygon();
        if (!this.geometry.getEnvelope().contains(nodePolygon.getEnvelope())) {
            return false;
        }
        if (GeometryUtilities.isRectangle(ownPolygon)) {
            return ownPolygon.getEnvelope().contains(nodePolygon.getEnvelope());
        }
        return this.contains(node.asLinearRing());
    }

    private boolean contains(ILinearRing ring) {
        if (this.operator == null) {
            this.operator = new ContainsLinearRingOperator(this.geometry);
        }
        return this.operator.contains(ring);
    }

    @Override
    public ILinearRing asExteriorRing() {
        if (!CoordinateSequenceOrientationCalculator.isOrientationPositive((ICoordinateSequence)this.geometry.getCoordinateSequence())) {
            return this.geometry;
        }
        return this.factoryProvider.getGeometryFactory(this.geometry.getCoordinateReferenceSystem()).createLinearRing(CoordinateSequenceUtilities.reverse((ICoordinateSequence)this.geometry.getCoordinateSequence()));
    }

    @Override
    public ILinearRing asInnerRing() {
        if (CoordinateSequenceOrientationCalculator.isOrientationPositive((ICoordinateSequence)this.geometry.getCoordinateSequence())) {
            return this.geometry;
        }
        return this.factoryProvider.getGeometryFactory(this.geometry.getCoordinateReferenceSystem()).createLinearRing(CoordinateSequenceUtilities.reverse((ICoordinateSequence)this.geometry.getCoordinateSequence()));
    }

    @Override
    public ILinearRing asLinearRing() {
        return this.geometry;
    }

    @Override
    public IPolygon asPolygon() {
        if (this.polygon == null) {
            this.polygon = this.factoryProvider.getGeometryFactory(this.geometry.getCoordinateReferenceSystem()).createPolygon(this.geometry, new LinearRing[0]);
        }
        return this.polygon;
    }
}

