/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.ring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.IGeometryFactoryProvider;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.ring.ILinearRingBuilder;

public class LinearRingBuilder
implements ILinearRingBuilder {
    private static ILogger logger = Logging.getLogger((String)LinearRingBuilder.class.getName());
    final List<ILineString> lineStrings = new ArrayList<ILineString>();
    private final IGeometryFactoryProvider geometryFactoryProvider;
    private ICoordinateReferenceSystem coordinateReferenceSystem;
    private double tolerance = -1.0;

    public LinearRingBuilder(IGeometryFactoryProvider geometryFactoryProvider) {
        this.geometryFactoryProvider = geometryFactoryProvider;
    }

    @Override
    public ILinearRingBuilder setTolerance(double tolerance) {
        this.tolerance = tolerance;
        return this;
    }

    @Override
    public ILinearRingBuilder add(ILineString lineString) {
        if (this.coordinateReferenceSystem == null) {
            this.coordinateReferenceSystem = lineString.getCoordinateReferenceSystem();
        } else if (!this.coordinateReferenceSystem.equals(lineString.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException();
        }
        this.lineStrings.add(lineString);
        return this;
    }

    @Override
    public List<ILinearRing> build() {
        IGeometryFactory geometryFactory = this.geometryFactoryProvider.getGeometryFactory(this.coordinateReferenceSystem);
        ArrayList<ILinearRing> result = new ArrayList<ILinearRing>();
        Sequences sequences = new Sequences();
        for (ILineString lineString : this.lineStrings) {
            if (lineString instanceof ILinearRing) {
                result.add((ILinearRing)lineString);
                continue;
            }
            ICoordinateSequence coordinateSequence = lineString.getCoordinateSequence();
            if (coordinateSequence.isClosed()) {
                result.add(geometryFactory.createLinearRing(coordinateSequence));
                continue;
            }
            if (!sequences.touches(coordinateSequence)) {
                sequences.add(coordinateSequence);
                continue;
            }
            List<ICoordinateSequence> touchedSequences = sequences.touched(coordinateSequence);
            ICoordinateSequence dummy = coordinateSequence;
            for (ICoordinateSequence touchedSequence : touchedSequences) {
                ICoordinateSequence tmp = this.concat(dummy, touchedSequence);
                if (tmp == null) continue;
                dummy = CoordinateSequenceUtilities.clean((ICoordinateSequence)tmp, (double)this.tolerance);
                sequences.remove(touchedSequence);
            }
            if (dummy.isClosed()) {
                result.add(geometryFactory.createLinearRing(dummy));
                continue;
            }
            sequences.add(dummy);
        }
        if (sequences.isEmpty()) {
            return result;
        }
        if (sequences.size() == 1) {
            ICoordinateSequence coordinateSequence = sequences.get(0);
            ICoordinateSequence closed = CoordinateSequenceUtilities.concat((ICoordinateSequence)coordinateSequence, (ICoordinate)coordinateSequence.getCoordinateN(0));
            result.add(geometryFactory.createLinearRing(closed));
        }
        return result;
    }

    private ICoordinateSequence concat(ICoordinateSequence sequence, ICoordinateSequence other) {
        if (sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1).equals(other.getCoordinateN(0))) {
            return CoordinateSequenceUtilities.concat((ICoordinateSequence)sequence, (ICoordinateSequence)other);
        }
        if (other.getCoordinateN(other.getNumberOfCoordinates() - 1).equals(sequence.getCoordinateN(0))) {
            return CoordinateSequenceUtilities.concat((ICoordinateSequence)other, (ICoordinateSequence)sequence);
        }
        if (sequence.getCoordinateN(0).equals(other.getCoordinateN(0))) {
            return CoordinateSequenceUtilities.concat((ICoordinateSequence)CoordinateSequenceUtilities.reverse((ICoordinateSequence)sequence), (ICoordinateSequence)other);
        }
        if (sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1).equals(other.getCoordinateN(other.getNumberOfCoordinates() - 1))) {
            return CoordinateSequenceUtilities.concat((ICoordinateSequence)sequence, (ICoordinateSequence)CoordinateSequenceUtilities.reverse((ICoordinateSequence)other));
        }
        return null;
    }

    public static interface ISequences {
        public void add(ICoordinateSequence var1);

        public ICoordinate nearestNeighbor(ICoordinate var1);

        public ICoordinateSequence get(int var1);

        public int size();

        public boolean isEmpty();

        public void remove(ICoordinateSequence var1);

        public boolean containts(ICoordinate var1);

        public ICoordinateSequence get(ICoordinate var1);

        public boolean touches(ICoordinateSequence var1);

        public List<ICoordinateSequence> touched(ICoordinateSequence var1);
    }

    public static class Sequences
    implements ISequences {
        final List<ICoordinateSequence> sequences = new ArrayList<ICoordinateSequence>();
        final Map<ICoordinate, ICoordinateSequence> sequencesByFirstCoordinate = new HashMap<ICoordinate, ICoordinateSequence>();
        final Map<ICoordinate, ICoordinateSequence> sequencesByLastCoordinate = new HashMap<ICoordinate, ICoordinateSequence>();

        @Override
        public void add(ICoordinateSequence sequence) {
            logger.log(ILevel.DEBUG, "add sequence " + sequence.getCoordinateN(0) + " " + sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1) + " " + sequence.getNumberOfCoordinates());
            this.sequences.add(sequence);
            this.sequencesByFirstCoordinate.put(sequence.getCoordinateN(0), sequence);
            this.sequencesByLastCoordinate.put(sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1), sequence);
        }

        @Override
        public void remove(ICoordinateSequence sequence) {
            logger.log(ILevel.DEBUG, "remove sequence " + sequence.getCoordinateN(0) + " " + sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1) + " " + sequence.getNumberOfCoordinates());
            this.sequences.remove(sequence);
            this.sequencesByFirstCoordinate.remove(sequence.getCoordinateN(0));
            this.sequencesByLastCoordinate.remove(sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1));
        }

        @Override
        public boolean touches(ICoordinateSequence sequence) {
            if (this.isEmpty()) {
                return false;
            }
            return this.containts(sequence.getCoordinateN(0)) || this.containts(sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1));
        }

        @Override
        public boolean isEmpty() {
            if (this.sequencesByFirstCoordinate.isEmpty() != this.sequencesByLastCoordinate.isEmpty()) {
                throw new IllegalStateException();
            }
            return this.sequencesByFirstCoordinate.isEmpty() && this.sequencesByLastCoordinate.isEmpty();
        }

        @Override
        public int size() {
            if (this.sequencesByFirstCoordinate.size() != this.sequencesByLastCoordinate.size()) {
                throw new IllegalStateException();
            }
            return this.sequencesByFirstCoordinate.size();
        }

        @Override
        public List<ICoordinateSequence> touched(ICoordinateSequence sequence) {
            HashSet<ICoordinateSequence> result = new HashSet<ICoordinateSequence>();
            ICoordinate firstCoordinate = sequence.getCoordinateN(0);
            ICoordinate lastCoordinate = sequence.getCoordinateN(sequence.getNumberOfCoordinates() - 1);
            if (this.containts(firstCoordinate)) {
                result.add(this.get(firstCoordinate));
            }
            if (this.containts(lastCoordinate)) {
                result.add(this.get(lastCoordinate));
            }
            return new ArrayList<ICoordinateSequence>(result);
        }

        @Override
        public boolean containts(ICoordinate coordinate) {
            return this.sequencesByFirstCoordinate.containsKey(coordinate) || this.sequencesByLastCoordinate.containsKey(coordinate);
        }

        @Override
        public ICoordinate nearestNeighbor(ICoordinate coordinate) {
            ICoordinate nearest = null;
            for (ICoordinate other : this.sequencesByFirstCoordinate.keySet()) {
                if (nearest == null) {
                    nearest = other;
                    continue;
                }
                if (CoordinateUtilities.calculateDistance((ICoordinate)coordinate, (ICoordinate)other) > CoordinateUtilities.calculateDistance((ICoordinate)coordinate, (ICoordinate)nearest)) continue;
                nearest = other;
            }
            for (ICoordinate other : this.sequencesByLastCoordinate.keySet()) {
                if (nearest == null) {
                    nearest = other;
                    continue;
                }
                if (CoordinateUtilities.calculateDistance((ICoordinate)coordinate, (ICoordinate)other) > CoordinateUtilities.calculateDistance((ICoordinate)coordinate, (ICoordinate)nearest)) continue;
                nearest = other;
            }
            return nearest;
        }

        @Override
        public ICoordinateSequence get(ICoordinate coordinate) {
            if (this.sequencesByFirstCoordinate.containsKey(coordinate)) {
                return this.sequencesByFirstCoordinate.get(coordinate);
            }
            if (this.sequencesByLastCoordinate.containsKey(coordinate)) {
                return this.sequencesByLastCoordinate.get(coordinate);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public ICoordinateSequence get(int index) {
            return this.sequences.get(index);
        }
    }
}

