/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.TestGeometryFactory;
import net.anwiba.spatial.geometry.junit.GeometryAssert;
import org.junit.Test;

public class GeometySerializationTest {
    @Test
    public void point() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createPoint());
    }

    @Test
    public void multiPoint() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createMultiPoint());
    }

    @Test
    public void lineString() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createLineString());
    }

    @Test
    public void multiLineString() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createMultiLineString());
    }

    @Test
    public void linearRing() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createLinearRing());
    }

    @Test
    public void polygon() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createPolygonWithHoles());
    }

    @Test
    public void multiPolygon() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createMultiPolygonWithHoles());
    }

    public void assertSerializable(IGeometry geometry) throws IOException, ClassNotFoundException {
        GeometryAssert.assertEquals(geometry, this.writeRead(geometry));
    }

    private <T extends Serializable> T writeRead(T object) throws IOException, ClassNotFoundException {
        byte[] array = this.write(object);
        return this.read(array);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Serializable> byte[] write(T object) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ByteArrayOutputStream memory = new ByteArrayOutputStream();
            try {
                byte[] byArray;
                block14: {
                    ObjectOutputStream out = new ObjectOutputStream(memory);
                    try {
                        out.writeObject(object);
                        byArray = memory.toByteArray();
                        return byArray;
                    }
                    finally {
                        if (out == null) break block14;
                        out.close();
                    }
                }
                if (memory != null) {
                    memory.close();
                }
                return byArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (memory == null) throw throwable;
                memory.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Serializable> T read(byte[] array) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ByteArrayInputStream memory = new ByteArrayInputStream(array);
            try {
                Serializable serializable;
                block14: {
                    ObjectInputStream in = new ObjectInputStream(memory);
                    try {
                        serializable = (Serializable)in.readObject();
                        return (T)serializable;
                    }
                    finally {
                        if (in == null) break block14;
                        in.close();
                    }
                }
                if (memory != null) {
                    memory.close();
                }
                return (T)serializable;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (memory == null) throw throwable;
                memory.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

