/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.extract;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.TestGeometryFactory;
import net.anwiba.spatial.geometry.extract.GeometryExtractor;
import net.anwiba.spatial.geometry.extract.GeometryReferenceFactory;
import net.anwiba.spatial.geometry.junit.GeometryAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;

public class GeometryExtractorTest
extends GeometryAssert {
    GeometryReferenceFactory factory = new GeometryReferenceFactory();

    @Test
    public void extract_neutral() {
        IPoint geometry = TestGeometryFactory.createPoint();
        GeometryExtractor extractor = new GeometryExtractor((IGeometry)geometry);
        GeometryExtractorTest.assertThat((Object)geometry, (Matcher)CoreMatchers.equalTo((Object)extractor.extract(this.factory.create(new int[0]))));
    }

    @Test
    public void extract_coordinate() {
        ILineString geometry = TestGeometryFactory.createLineString();
        GeometryExtractor extractor = new GeometryExtractor((IGeometry)geometry);
        GeometryExtractorTest.assertEquals((ICoordinate)geometry.getCoordinateN(1), (ICoordinate)extractor.extract(this.factory.create(new int[]{1})).getCoordinateN(0));
    }

    @Test
    public void extract_basegeometry() {
        IGeometryCollection geometry = TestGeometryFactory.createGeometryCollection();
        GeometryExtractor extractor = new GeometryExtractor((IGeometry)geometry);
        GeometryExtractorTest.assertThat((Object)geometry.getGeometryN(1), (Matcher)CoreMatchers.sameInstance((Object)extractor.extract(this.factory.create(new int[]{1}))));
    }
}

