/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.impl;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.junit.CoordinateAssert;
import net.anwiba.spatial.coordinate.junit.CoordinateSequenceAssert;
import net.anwiba.spatial.coordinatereferencesystem.coordinatesystem.ITestCoordinateReferenceSystem;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.IMultiPoint;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.internal.GeometryFactory;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeometryFactoryTest {
    IGeometryFactory geometryFactory;
    private final ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    @Before
    public void setUp() throws Exception {
        this.geometryFactory = GeometryUtilities.getDefaultGeometryFactory();
    }

    @Test
    public void testPoint() throws Exception {
        Coordinate expectedCoordinate = new Coordinate(5.0, 5.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(new ICoordinate[]{expectedCoordinate});
        IPoint point = this.geometryFactory.createPoint((ICoordinate)expectedCoordinate);
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)point.getCoordinateSequence());
        Assert.assertEquals((long)1L, (long)point.getNumberOfCoordinates());
        CoordinateAssert.assertEquals((ICoordinate)expectedCoordinate, (ICoordinate)point.getCoordinateN(0));
        Assert.assertEquals((long)0L, (long)point.getDimension());
        Assert.assertEquals((Object)GeometryType.POINT, (Object)point.getGeometryType());
        Assert.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)point.getCoordinateReferenceSystem());
    }

    @Test
    public void testMultiPoint() throws Exception {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01});
        IMultiPoint point = this.geometryFactory.createMultiPoint(expectedCoordinateSequence);
        Assert.assertEquals((long)2L, (long)point.getNumberOfGeometries());
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)point.getCoordinateSequence());
        Assert.assertEquals((long)2L, (long)point.getNumberOfCoordinates());
        CoordinateAssert.assertEquals((ICoordinate)coordinate00, (ICoordinate)point.getCoordinateN(0));
        CoordinateAssert.assertEquals((ICoordinate)coordinate01, (ICoordinate)point.getCoordinateN(1));
        Assert.assertEquals((long)2L, (long)point.getDimension());
        Assert.assertEquals((Object)GeometryType.MULTIPOINT, (Object)point.getGeometryType());
        Assert.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)point.getCoordinateReferenceSystem());
    }

    @Test
    public void testLineString() throws Exception {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(new ICoordinate[]{coordinate00, coordinate01});
        ILineString lineString = this.geometryFactory.createLineString(expectedCoordinateSequence);
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)lineString.getCoordinateSequence());
        Assert.assertEquals((long)2L, (long)lineString.getNumberOfCoordinates());
        CoordinateAssert.assertEquals((ICoordinate)coordinate00, (ICoordinate)lineString.getCoordinateN(0));
        CoordinateAssert.assertEquals((ICoordinate)coordinate01, (ICoordinate)lineString.getCoordinateN(1));
        Assert.assertEquals((long)1L, (long)lineString.getDimension());
        Assert.assertEquals((Object)GeometryType.LINESTRING, (Object)lineString.getGeometryType());
        Assert.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)lineString.getCoordinateReferenceSystem());
    }

    @Test
    public void testLinearRing() throws Exception {
        double[] xs = new double[]{50.0, 50.0, 100.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 100.0, 50.0};
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(xs, ys);
        ILinearRing linearRing = this.geometryFactory.createLinearRing(expectedCoordinateSequence);
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)linearRing.getCoordinateSequence());
        Assert.assertEquals((long)4L, (long)linearRing.getNumberOfCoordinates());
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0], ys[0]), (ICoordinate)linearRing.getCoordinateN(0));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1], ys[1]), (ICoordinate)linearRing.getCoordinateN(1));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[2], ys[2]), (ICoordinate)linearRing.getCoordinateN(2));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[3], ys[3]), (ICoordinate)linearRing.getCoordinateN(3));
        Assert.assertEquals((long)1L, (long)linearRing.getDimension());
        Assert.assertEquals((Object)GeometryType.LINEARRING, (Object)linearRing.getGeometryType());
        Assert.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)linearRing.getCoordinateReferenceSystem());
    }

    @Test
    public void testMultiLineString() throws Exception {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        IMultiLineString multiLineString = this.geometryFactory.createMultiLineString((double[][])xs, (double[][])ys);
        Assert.assertEquals((long)2L, (long)multiLineString.getNumberOfGeometries());
        Assert.assertEquals((long)8L, (long)multiLineString.getNumberOfCoordinates());
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][0], ys[0][0]), (ICoordinate)multiLineString.getCoordinateN(0));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][1], ys[0][1]), (ICoordinate)multiLineString.getCoordinateN(1));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][2], ys[0][2]), (ICoordinate)multiLineString.getCoordinateN(2));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][3], ys[0][3]), (ICoordinate)multiLineString.getCoordinateN(3));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][0], ys[1][0]), (ICoordinate)multiLineString.getCoordinateN(4));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][1], ys[1][1]), (ICoordinate)multiLineString.getCoordinateN(5));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][2], ys[1][2]), (ICoordinate)multiLineString.getCoordinateN(6));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][3], ys[1][3]), (ICoordinate)multiLineString.getCoordinateN(7));
        Assert.assertEquals((long)2L, (long)multiLineString.getDimension());
        Assert.assertEquals((long)2L, (long)multiLineString.getCoordinateDimension());
        Assert.assertEquals((Object)GeometryType.MULTILINESTRING, (Object)multiLineString.getGeometryType());
        Assert.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)multiLineString.getCoordinateReferenceSystem());
    }

    @Test
    public void testMultiLineStringZ() throws Exception {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        double[][] zs = new double[][]{{30.0, 33.0, 31.0, 45.0}, {20.0, 22.0, 26.0, 28.0}};
        IMultiLineString multiLineString = this.geometryFactory.createMultiLineString((double[][])xs, (double[][])ys, (double[][])zs);
        Assert.assertEquals((long)2L, (long)multiLineString.getNumberOfGeometries());
        Assert.assertEquals((long)8L, (long)multiLineString.getNumberOfCoordinates());
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][0], ys[0][0], zs[0][0], false), (ICoordinate)multiLineString.getCoordinateN(0));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][1], ys[0][1], zs[0][1], false), (ICoordinate)multiLineString.getCoordinateN(1));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][2], ys[0][2], zs[0][2], false), (ICoordinate)multiLineString.getCoordinateN(2));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[0][3], ys[0][3], zs[0][3], false), (ICoordinate)multiLineString.getCoordinateN(3));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][0], ys[1][0], zs[1][0], false), (ICoordinate)multiLineString.getCoordinateN(4));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][1], ys[1][1], zs[1][1], false), (ICoordinate)multiLineString.getCoordinateN(5));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][2], ys[1][2], zs[1][2], false), (ICoordinate)multiLineString.getCoordinateN(6));
        CoordinateAssert.assertEquals((ICoordinate)new Coordinate(xs[1][3], ys[1][3], zs[1][3], false), (ICoordinate)multiLineString.getCoordinateN(7));
        Assert.assertEquals((long)2L, (long)multiLineString.getDimension());
        Assert.assertEquals((long)3L, (long)multiLineString.getCoordinateDimension());
        Assert.assertEquals((Object)GeometryType.MULTILINESTRING, (Object)multiLineString.getGeometryType());
        Assert.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)multiLineString.getCoordinateReferenceSystem());
    }

    @Test
    public void testGetTargetCoordianteReferenceSystem() {
        GeometryFactory factory = new GeometryFactory(ITestCoordinateReferenceSystem.GG_WGS_84);
        Assert.assertThat((Object)factory.getCoordinateReferenceSystem(), (Matcher)CoreMatchers.equalTo((Object)ITestCoordinateReferenceSystem.GG_WGS_84));
        factory = new GeometryFactory(ITestCoordinateReferenceSystem.GG_WGS_84);
        Assert.assertThat((Object)factory.getCoordinateReferenceSystem(), (Matcher)CoreMatchers.equalTo((Object)ITestCoordinateReferenceSystem.GG_WGS_84));
    }
}

