/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon;

import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.IGeometryFactoryProvider;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.TestGeometryFactory;
import net.anwiba.spatial.geometry.polygon.MultiPolygonBuilder;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiPolygonBuilderTest {
    private final IGeometryFactoryProvider factoryProvider = new IGeometryFactoryProvider(){

        public IGeometryFactory getGeometryFactory(ICoordinateReferenceSystem coordinateReferenceSystem) {
            return GeometryUtilities.getDefaultGeometryFactory();
        }
    };

    @Test
    public void testShellHole() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing hole = TestGeometryFactory.createHoleLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(shell);
        builder.add(hole);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getNumberOfInnerRings(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getInnerRingN(0), (Matcher)CoreMatchers.equalTo((Object)hole));
    }

    @Test
    public void testShellRevertedHole() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing hole = TestGeometryFactory.createRevertedHoleLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(shell);
        builder.add(hole);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getNumberOfInnerRings(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getInnerRingN(0), (Matcher)CoreMatchers.equalTo((Object)hole));
    }

    @Test
    public void testHolesShell() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing hole = TestGeometryFactory.createHoleLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(hole);
        builder.add(shell);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getNumberOfInnerRings(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getInnerRingN(0), (Matcher)CoreMatchers.equalTo((Object)hole));
    }

    @Test
    public void testRevertedHolesShell() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing hole = TestGeometryFactory.createRevertedHoleLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(hole);
        builder.add(shell);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getNumberOfInnerRings(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getInnerRingN(0), (Matcher)CoreMatchers.equalTo((Object)hole));
    }

    @Test
    public void testShellNeigbourHole() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing neigbour = TestGeometryFactory.createNeighbourShellLinearRing();
        ILinearRing hole = TestGeometryFactory.createRevertedHoleLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(shell);
        builder.add(neigbour);
        builder.add(hole);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
        Assert.assertThat((Object)multiPolygon.getGeometryN(1).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)neigbour));
    }

    @Test
    public void testShellHoleNeigbour() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing neigbour = TestGeometryFactory.createNeighbourShellLinearRing();
        ILinearRing hole = TestGeometryFactory.createRevertedHoleLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(shell);
        builder.add(hole);
        builder.add(neigbour);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
        Assert.assertThat((Object)multiPolygon.getGeometryN(1).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)neigbour));
    }

    @Test
    public void testHoleShellNeigbour() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing neigbour = TestGeometryFactory.createNeighbourShellLinearRing();
        ILinearRing hole = TestGeometryFactory.createRevertedHoleLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(hole);
        builder.add(shell);
        builder.add(neigbour);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
        Assert.assertThat((Object)multiPolygon.getGeometryN(1).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)neigbour));
    }

    @Test
    public void testNeigbourShell() {
        ILinearRing shell = TestGeometryFactory.createShellLinearRing();
        ILinearRing neigbour = TestGeometryFactory.createNeighbourShellLinearRing();
        MultiPolygonBuilder builder = new MultiPolygonBuilder(this.factoryProvider);
        builder.add(neigbour);
        builder.add(shell);
        IMultiPolygon multiPolygon = builder.build();
        Assert.assertThat((Object)multiPolygon, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)multiPolygon.getNumberOfGeometries(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)multiPolygon.getGeometryN(0).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)neigbour));
        Assert.assertThat((Object)multiPolygon.getGeometryN(1).getOuterRing(), (Matcher)CoreMatchers.equalTo((Object)shell));
    }
}

