/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;

public class GeometryValidator {
    public static boolean isValidLinearRing(ICoordinateSequence coordinateSequence) {
        try {
            GeometryValidator.ensureIsLinearRing(coordinateSequence);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static void ensureIsLinearRing(ICoordinateSequence sequence) {
        ICoordinate lastCoordinate;
        if (sequence.getDimension() < 2) {
            throw new IllegalArgumentException("Coordinate dimension (" + sequence.getDimension() + ") is to small for a Linearring");
        }
        int coordinateCount = sequence.getNumberOfCoordinates();
        if (coordinateCount < 3) {
            throw new IllegalArgumentException("Linearring needs more than two coordinates");
        }
        ICoordinate firstCoordinate = sequence.getCoordinateN(0);
        if (!firstCoordinate.equals(lastCoordinate = sequence.getCoordinateN(coordinateCount - 1))) {
            throw new IllegalArgumentException("first and last coordinare must be equal for Linearrings");
        }
    }
}

