/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon;

import java.util.List;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.ILineSegment;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.operator.IEnvelopeConverter;
import net.anwiba.spatial.geometry.operator.LineIntersector;
import net.anwiba.spatial.geometry.operator.Rtree;
import net.anwiba.spatial.geometry.utilities.LineSegmentIterable;

public class ContainsLinearRingOperator {
    private Rtree<ILineSegment> tree;
    private final double minX;
    private final double maxX;
    private final double horizontalAuxiliaryXValue;
    private final ILinearRing baseRing;

    public ContainsLinearRingOperator(ILinearRing ring) {
        this.baseRing = ring;
        IEnvelope envelope = ring.getEnvelope();
        this.minX = envelope.getMinimum().getXValue();
        this.maxX = envelope.getMaximum().getXValue();
        this.horizontalAuxiliaryXValue = this.maxX + 10.0;
    }

    private Rtree<ILineSegment> createTree(ILinearRing ring) {
        Rtree<ILineSegment> rTree = new Rtree<ILineSegment>(new IEnvelopeConverter<ILineSegment>(){

            @Override
            public int getDimensions() {
                return 1;
            }

            @Override
            public double getMin(int axis, ILineSegment lineSegment) {
                if (axis == 0) {
                    return Math.min(lineSegment.getStartPoint().getYValue(), lineSegment.getEndPoint().getYValue());
                }
                throw new IllegalArgumentException();
            }

            @Override
            public double getMax(int axis, ILineSegment lineSegment) {
                if (axis == 0) {
                    return Math.max(lineSegment.getStartPoint().getYValue(), lineSegment.getEndPoint().getYValue());
                }
                throw new IllegalArgumentException();
            }
        });
        LineSegmentIterable lineSegments = new LineSegmentIterable(ring.getCoordinateSequence());
        for (ILineSegment lineSegment : lineSegments) {
            rTree.insert(lineSegment);
        }
        rTree.build();
        return rTree;
    }

    public boolean contains(ILinearRing ring) {
        return this.contains(ring, true);
    }

    public boolean contains(ILineString ring, boolean borderTouch) {
        int i = 0;
        while (i < ring.getNumberOfCoordinates()) {
            ICoordinate coordinate = ring.getCoordinateN(i);
            if (!this.contains(coordinate, borderTouch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean containsOrCross(ILineString ring) {
        int i = 0;
        while (i < ring.getNumberOfCoordinates() - 1) {
            ICoordinate startPoint = ring.getCoordinateN(i);
            ICoordinate endPoint = ring.getCoordinateN(i + 1);
            if (this.contains(startPoint, true)) {
                return true;
            }
            if (this.cross(startPoint, endPoint)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(ICoordinate coordinate, boolean touchEnabled) {
        if (this.minX > coordinate.getXValue() || coordinate.getXValue() > this.maxX) {
            return false;
        }
        ICoordinate otherCoordinate = this.createHorizontalAuxiliaryCoordinate(coordinate);
        List<ILineSegment> lineSegments = this.getTree().query(coordinate.getYValue());
        int intersectionCounter = 0;
        for (ILineSegment lineSegment : lineSegments) {
            LineIntersector lineIntersector = new LineIntersector();
            lineIntersector.computeIntersection(lineSegment.getStartPoint(), lineSegment.getEndPoint(), coordinate, otherCoordinate);
            if (!lineIntersector.hasIntersection()) continue;
            if (lineIntersector.isIntersection(coordinate)) {
                return touchEnabled;
            }
            if (lineIntersector.isIntersection(lineSegment.getStartPoint().getYValue() < lineSegment.getEndPoint().getYValue() ? lineSegment.getStartPoint() : lineSegment.getEndPoint())) continue;
            ++intersectionCounter;
        }
        return intersectionCounter % 2 == 1;
    }

    protected boolean cross(ICoordinate startPoint, ICoordinate endPoint) {
        List<ILineSegment> lineSegments = this.getTree().query(startPoint.getYValue(), endPoint.getYValue());
        for (ILineSegment lineSegment : lineSegments) {
            LineIntersector lineIntersector = new LineIntersector();
            lineIntersector.computeIntersection(lineSegment.getStartPoint(), lineSegment.getEndPoint(), startPoint, endPoint);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    private ICoordinate createHorizontalAuxiliaryCoordinate(ICoordinate coordinate) {
        return new Coordinate(this.horizontalAuxiliaryXValue, coordinate.getYValue());
    }

    public Rtree<ILineSegment> getTree() {
        if (this.tree == null) {
            this.tree = this.createTree(this.baseRing);
        }
        return this.tree;
    }
}

