/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.IBaseGeometry;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.IGeometryTypeVisitor;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.IMultiPoint;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;

public class TestGeometryFactory {
    private static final ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();
    private static IGeometryFactory geometryFactory = GeometryUtilities.getDefaultGeometryFactory();

    public static IGeometryFactory getGeometryFactory() {
        return geometryFactory;
    }

    public static IGeometry create(GeometryType geometryType) {
        return (IGeometry)geometryType.accept((IGeometryTypeVisitor)new IGeometryTypeVisitor<IGeometry, RuntimeException>(){

            public IGeometry visitCollection() throws RuntimeException {
                return TestGeometryFactory.createGeometryCollection();
            }

            public IGeometry visitLineString() throws RuntimeException {
                return TestGeometryFactory.createLineString();
            }

            public IGeometry visitLinearRing() throws RuntimeException {
                return TestGeometryFactory.createLinearRing();
            }

            public IGeometry visitMultiLineString() throws RuntimeException {
                return TestGeometryFactory.createMultiLineString();
            }

            public IGeometry visitMultiPoint() throws RuntimeException {
                return TestGeometryFactory.createMultiPoint();
            }

            public IGeometry visitMultiPolygon() throws RuntimeException {
                return TestGeometryFactory.createMultiPolygonWithHoles();
            }

            public IGeometry visitPoint() throws RuntimeException {
                return TestGeometryFactory.createPoint();
            }

            public IGeometry visitPolygon() throws RuntimeException {
                return TestGeometryFactory.createPolygon();
            }

            public IGeometry visitUnknown() throws RuntimeException {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static IPoint createPoint() {
        return geometryFactory.createPoint((ICoordinate)new Coordinate(5.0, 5.0));
    }

    public static IPoint createPointZ() {
        return geometryFactory.createPoint((ICoordinate)new Coordinate(5.0, 5.0, 5.0, false));
    }

    public static IPoint createPointZM() {
        return geometryFactory.createPoint((ICoordinate)new Coordinate(5.0, 5.0, 5.0, 5.0));
    }

    public static IPoint createPointM() {
        return geometryFactory.createPoint((ICoordinate)new Coordinate(5.0, 5.0, 5.0, true));
    }

    public static IMultiPoint createOnePointMultiPoint() {
        Coordinate coordinate = new Coordinate(5.0, 5.0);
        return geometryFactory.createMultiPoint(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate}));
    }

    public static IMultiPoint createMultiPoint() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0);
        return geometryFactory.createMultiPoint(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static IMultiPoint createMultiPointZ() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0, 5.0, false);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0, 5.0, false);
        return geometryFactory.createMultiPoint(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static IMultiPoint createMultiPointM() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0, 5.0, true);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0, 5.0, true);
        return geometryFactory.createMultiPoint(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static IMultiPoint createMultiPointZM() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0, 5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0, 5.0, 5.0);
        return geometryFactory.createMultiPoint(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static ILineString createLineString() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0);
        return geometryFactory.createLineString(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static ILineString createLineStringZ() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0, 5.0, false);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0, 5.0, false);
        return geometryFactory.createLineString(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static ILineString createLineStringM() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0, 5.0, true);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0, 5.0, true);
        return geometryFactory.createLineString(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static ILineString createLineStringZM() {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0, 5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0, 5.0, 5.0);
        return geometryFactory.createLineString(coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01}));
    }

    public static ILinearRing createMirroredLinearRing() {
        double[] xs = new double[]{50.0, 50.0, 100.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 100.0, 50.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys));
    }

    public static ILinearRing createLinearRing() {
        double[] xs = new double[]{50.0, 150.0, 100.0, 50.0};
        double[] ys = new double[]{50.0, 50.0, 100.0, 50.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys));
    }

    public static ILinearRing createRevertedHoleLinearRing() {
        double[] xs = new double[]{75.0, 125.0, 125.0, 75.0, 75.0};
        double[] ys = new double[]{75.0, 75.0, 125.0, 125.0, 75.0};
        return geometryFactory.createLinearRing(CoordinateSequenceUtilities.reverse((ICoordinateSequence)coordinateSequenceFactory.create(xs, ys)));
    }

    public static ILinearRing createHoleLinearRing() {
        double[] xs = new double[]{75.0, 125.0, 125.0, 75.0, 75.0};
        double[] ys = new double[]{75.0, 75.0, 125.0, 125.0, 75.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys));
    }

    public static ILinearRing createShellLinearRing() {
        double[] xs = new double[]{50.0, 50.0, 150.0, 150.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 150.0, 50.0, 50.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys));
    }

    public static ILinearRing createNeighbourShellLinearRing() {
        double[] xs = new double[]{175.0, 175.0, 200.0, 200.0, 175.0};
        double[] ys = new double[]{50.0, 150.0, 150.0, 50.0, 50.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys));
    }

    public static ILinearRing createLinearRingZ() {
        double[] xs = new double[]{50.0, 50.0, 100.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 100.0, 50.0};
        double[] zs = new double[]{5.0, 5.0, 5.0, 5.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys, zs, false));
    }

    public static ILinearRing createLinearRingM() {
        double[] xs = new double[]{50.0, 50.0, 100.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 100.0, 50.0};
        double[] zs = new double[]{5.0, 5.0, 5.0, 5.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys, zs, true));
    }

    public static ILinearRing createLinearRingZM() {
        double[] xs = new double[]{50.0, 50.0, 100.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 100.0, 50.0};
        double[] zs = new double[]{5.0, 5.0, 5.0, 5.0};
        double[] ms = new double[]{5.0, 5.0, 5.0, 5.0};
        return geometryFactory.createLinearRing(coordinateSequenceFactory.create(xs, ys, zs, ms));
    }

    public static IMultiLineString createMultiLineString() {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        return geometryFactory.createMultiLineString((double[][])xs, (double[][])ys);
    }

    public static IMultiLineString createMultiLineStringZ() {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        double[][] zs = new double[][]{{30.0, 33.0, 31.0, 45.0}, {20.0, 22.0, 26.0, 28.0}};
        return geometryFactory.createMultiLineString((double[][])xs, (double[][])ys, (double[][])zs);
    }

    public static IMultiLineString createMultiLineStringM() {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        double[][] zs = new double[][]{{5.0, 5.0, 5.0, 5.0}, {5.0, 5.0, 5.0, 5.0}};
        return geometryFactory.createMultiLineString((double[][])xs, (double[][])ys, (double[][])zs, true);
    }

    public static IMultiLineString createMultiLineStringZM() {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        double[][] zs = new double[][]{{5.0, 5.0, 5.0, 5.0}, {5.0, 5.0, 5.0, 5.0}};
        double[][] ms = new double[][]{{5.0, 5.0, 5.0, 5.0}, {5.0, 5.0, 5.0, 5.0}};
        return geometryFactory.createMultiLineString((double[][])xs, (double[][])ys, (double[][])zs, (double[][])ms);
    }

    public static IPolygon createPolygon() {
        double[] xs = new double[]{50.0, 50.0, 150.0, 150.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 150.0, 50.0, 50.0};
        return geometryFactory.createPolygon(xs, ys);
    }

    public static IPolygon createPolygonZ() {
        double[] xs = new double[]{50.0, 50.0, 150.0, 150.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 150.0, 50.0, 50.0};
        double[] zs = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        return geometryFactory.createPolygon(coordinateSequenceFactory.create(xs, ys, zs, false));
    }

    public static IPolygon createPolygonM() {
        double[] xs = new double[]{50.0, 50.0, 150.0, 150.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 150.0, 50.0, 50.0};
        double[] zs = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        return geometryFactory.createPolygon(coordinateSequenceFactory.create(xs, ys, zs, true));
    }

    public static IPolygon createPolygonZM() {
        double[] xs = new double[]{50.0, 50.0, 150.0, 150.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 150.0, 50.0, 50.0};
        double[] zs = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        double[] ms = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        return geometryFactory.createPolygon(coordinateSequenceFactory.create(xs, ys, zs, ms));
    }

    public static IPolygon createPolygonWithHoles() {
        double[] xs = new double[]{50.0, 50.0, 150.0, 150.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 150.0, 50.0, 50.0};
        double[][] hxs = new double[][]{{75.0, 125.0, 125.0, 75.0, 75.0}};
        double[][] hys = new double[][]{{75.0, 75.0, 125.0, 125.0, 75.0}};
        return geometryFactory.createPolygon(xs, ys, (double[][])hxs, (double[][])hys);
    }

    public static IMultiPolygon createMultiPolygon() {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0, 50.0}, {175.0, 175.0, 200.0, 200.0, 175.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0, 50.0}, {50.0, 150.0, 150.0, 50.0, 50.0}};
        return geometryFactory.createMultiPolygon((double[][])xs, (double[][])ys);
    }

    public static IMultiPolygon createMultiPolygonWithHoles() {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0, 50.0}, {175.0, 175.0, 200.0, 200.0, 175.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0, 50.0}, {50.0, 150.0, 150.0, 50.0, 50.0}};
        double[][][] hxs = new double[][][]{new double[][]{{75.0, 125.0, 125.0, 75.0, 75.0}}, new double[0][]};
        double[][][] hys = new double[][][]{new double[][]{{75.0, 75.0, 125.0, 125.0, 75.0}}, new double[0][]};
        return geometryFactory.createMultiPolygon((double[][])xs, (double[][])ys, (double[][][])hxs, (double[][][])hys);
    }

    public static IGeometryCollection createGeometryCollection() {
        IBaseGeometry[] geometries = new IBaseGeometry[]{TestGeometryFactory.createPoint(), TestGeometryFactory.createLineString(), TestGeometryFactory.createPolygonWithHoles()};
        return geometryFactory.createCollection(geometries);
    }
}

