/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.junit;

import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.junit.CoordinateSequenceAssert;
import net.anwiba.spatial.geometry.IBaseGeometry;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.internal.LinearRing;

public class GeometryAssert
extends CoordinateSequenceAssert {
    public static void assertEquals(IGeometry expected, IGeometry actual) {
        GeometryAssert.assertEquals("", expected, actual);
    }

    private static void assertEquals(String message, IGeometry expected, IGeometry actual) {
        if (expected == null ? actual == null : expected == actual) {
            return;
        }
        if (expected == null) {
            GeometryAssert.fail((String)(String.valueOf(message) + "expected geometry was null"));
            return;
        }
        if (actual == null) {
            GeometryAssert.fail((String)(String.valueOf(message) + "actual geometry was null"));
            return;
        }
        if (!expected.getGeometryType().equals((Object)actual.getGeometryType())) {
            GeometryAssert.fail((String)(String.valueOf(message) + "geometryType differed, expected.geometryType=" + expected.getGeometryType() + " actual.geometryType=" + actual.getGeometryType()));
            return;
        }
        if (expected.isCollection()) {
            IGeometryCollection expectedCollection = (IGeometryCollection)expected;
            IGeometryCollection actualCollection = (IGeometryCollection)actual;
            GeometryAssert.assertGeometryCollectionsEquals(message, expectedCollection, actualCollection);
            return;
        }
        IBaseGeometry expectedBaseGeometry = (IBaseGeometry)expected;
        IBaseGeometry actualBaseGeometry = (IBaseGeometry)actual;
        GeometryAssert.assertBasicGeometriesEquals(message, expectedBaseGeometry, actualBaseGeometry);
    }

    private static void assertGeometryCollectionsEquals(String message, IGeometryCollection expected, IGeometryCollection actual) {
        if (expected.getNumberOfGeometries() != actual.getNumberOfGeometries()) {
            GeometryAssert.fail((String)(String.valueOf(message) + "number of base geometries differed, expected.numberOfGeometries=" + expected.getNumberOfGeometries() + " actual.numberOfGeometries=" + actual.getNumberOfGeometries()));
            return;
        }
        switch (expected.getGeometryType()) {
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                int i = 0;
                while (i < expected.getNumberOfGeometries()) {
                    IBaseGeometry expectedBaseGeometry = expected.getGeometryN(i);
                    IBaseGeometry actualBaseGeometry = actual.getGeometryN(i);
                    GeometryAssert.assertBasicGeometriesEquals(String.valueOf(message) + "base geometry " + i, expectedBaseGeometry, actualBaseGeometry);
                    ++i;
                }
                return;
            }
            case COLLECTION: 
            case UNKNOWN: {
                int i = 0;
                while (i < expected.getNumberOfGeometries()) {
                    if (!expected.getGeometryType().equals((Object)actual.getGeometryType())) {
                        GeometryAssert.fail((String)(String.valueOf(message) + "base geometry " + i + ", geometryType differed, expected.geometryType=" + expected.getGeometryType() + " actual.geometryType=" + actual.getGeometryType()));
                        return;
                    }
                    IBaseGeometry expectedBaseGeometry = expected.getGeometryN(i);
                    IBaseGeometry actualBaseGeometry = actual.getGeometryN(i);
                    GeometryAssert.assertBasicGeometriesEquals(String.valueOf(message) + "base geometry " + i + ", ", expectedBaseGeometry, actualBaseGeometry);
                    ++i;
                }
                return;
            }
        }
        throw new UnreachableCodeReachedException();
    }

    private static void assertBasicGeometriesEquals(String message, IBaseGeometry expected, IBaseGeometry actual) {
        switch (expected.getGeometryType()) {
            case POINT: 
            case LINESTRING: {
                CoordinateSequenceAssert.assertEquals((String)message, (ICoordinateSequence)expected.getCoordinateSequence(), (ICoordinateSequence)actual.getCoordinateSequence());
                return;
            }
            case LINEARRING: {
                LinearRing expectedLinearRing = (LinearRing)expected;
                LinearRing actualLinearRing = (LinearRing)actual;
                CoordinateSequenceAssert.assertEquals((String)message, (ICoordinateSequence)expected.getCoordinateSequence(), (ICoordinateSequence)(actualLinearRing.getOrientation().equals((Object)expectedLinearRing.getOrientation()) ? actual.getCoordinateSequence() : CoordinateSequenceUtilities.reverse((ICoordinateSequence)actual.getCoordinateSequence())));
                return;
            }
            case POLYGON: {
                IPolygon expectedPolygon = (IPolygon)expected;
                IPolygon actualPolygon = (IPolygon)actual;
                GeometryAssert.assertEquals((IGeometry)expectedPolygon.getOuterRing(), (IGeometry)actualPolygon.getOuterRing());
                if (expectedPolygon.getNumberOfInnerRings() != actualPolygon.getNumberOfInnerRings()) {
                    GeometryAssert.fail((String)(String.valueOf(message) + ", number off inner rings differed, expected.number=" + expectedPolygon.getNumberOfInnerRings() + " actual.number=" + actualPolygon.getNumberOfInnerRings()));
                }
                int i = 0;
                while (i < expectedPolygon.getNumberOfInnerRings()) {
                    GeometryAssert.assertEquals("innerring" + i + ", ", (IGeometry)expectedPolygon.getInnerRingN(i), (IGeometry)actualPolygon.getInnerRingN(i));
                    ++i;
                }
                return;
            }
        }
        throw new UnreachableCodeReachedException();
    }
}

