/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.extract;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.ILineSegment;
import net.anwiba.spatial.geometry.operator.IEnvelopeConverter;
import net.anwiba.spatial.geometry.operator.Rtree;
import net.anwiba.spatial.geometry.utilities.LineSegmentIterable;

public class LineSegmentExtractor {
    private final IGeometry geometry;
    private Rtree<ILineSegment> tree;

    public LineSegmentExtractor(IGeometry geometry) {
        this.geometry = geometry;
    }

    public List<ILineSegment> find(ICoordinate coordinate) {
        if (this.tree == null) {
            this.tree = this.createTree(this.geometry);
        }
        List<ILineSegment> segments = this.tree.query(coordinate.getYValue());
        ArrayList<ILineSegment> result = new ArrayList<ILineSegment>();
        for (ILineSegment segment : segments) {
            if (!CoordinateUtilities.isBetween((ICoordinate)segment.getStartPoint(), (ICoordinate)segment.getEndPoint(), (ICoordinate)coordinate, (double)Double.NaN)) continue;
            result.add(segment);
        }
        return result;
    }

    private Rtree<ILineSegment> createTree(IGeometry geometry) {
        Rtree<ILineSegment> rTree = new Rtree<ILineSegment>(new IEnvelopeConverter<ILineSegment>(){

            @Override
            public int getDimensions() {
                return 1;
            }

            @Override
            public double getMin(int axis, ILineSegment lineSegment) {
                if (axis == 0) {
                    return Math.min(lineSegment.getStartPoint().getYValue(), lineSegment.getEndPoint().getYValue());
                }
                throw new IllegalArgumentException();
            }

            @Override
            public double getMax(int axis, ILineSegment lineSegment) {
                if (axis == 0) {
                    return Math.max(lineSegment.getStartPoint().getYValue(), lineSegment.getEndPoint().getYValue());
                }
                throw new IllegalArgumentException();
            }
        });
        LineSegmentIterable lineSegments = new LineSegmentIterable(geometry.getCoordinateSequence());
        for (ILineSegment lineSegment : lineSegments) {
            rTree.insert(lineSegment);
        }
        rTree.build();
        return rTree;
    }
}

