/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.impl;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.junit.CoordinateSequenceAssert;
import net.anwiba.spatial.coordinatereferencesystem.coordinatesystem.ITestCoordinateReferenceSystem;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.IMultiPoint;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.internal.GeometryFactory;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GeometryFactoryTest {
    IGeometryFactory geometryFactory;
    private final ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    @BeforeEach
    public void setUp() throws Exception {
        this.geometryFactory = GeometryUtilities.getDefaultGeometryFactory();
    }

    @Test
    public void testPoint() throws Exception {
        Coordinate expectedCoordinate = new Coordinate(5.0, 5.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(new ICoordinate[]{expectedCoordinate});
        IPoint point = this.geometryFactory.createPoint((ICoordinate)expectedCoordinate);
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)point.getCoordinateSequence());
        Assertions.assertEquals((int)1, (int)point.getNumberOfCoordinates());
        Assertions.assertEquals((Object)expectedCoordinate, (Object)point.getCoordinateN(0));
        Assertions.assertEquals((int)0, (int)point.getDimension());
        Assertions.assertEquals((Object)GeometryType.POINT, (Object)point.getGeometryType());
        Assertions.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)point.getCoordinateReferenceSystem());
    }

    @Test
    public void testMultiPoint() throws Exception {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create((ICoordinate[])new Coordinate[]{coordinate00, coordinate01});
        IMultiPoint point = this.geometryFactory.createMultiPoint(expectedCoordinateSequence);
        Assertions.assertEquals((int)2, (int)point.getNumberOfGeometries());
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)point.getCoordinateSequence());
        Assertions.assertEquals((int)2, (int)point.getNumberOfCoordinates());
        Assertions.assertEquals((Object)coordinate00, (Object)point.getCoordinateN(0));
        Assertions.assertEquals((Object)coordinate01, (Object)point.getCoordinateN(1));
        Assertions.assertEquals((int)2, (int)point.getDimension());
        Assertions.assertEquals((Object)GeometryType.MULTIPOINT, (Object)point.getGeometryType());
        Assertions.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)point.getCoordinateReferenceSystem());
    }

    @Test
    public void testLineString() throws Exception {
        Coordinate coordinate00 = new Coordinate(5.0, 5.0);
        Coordinate coordinate01 = new Coordinate(15.0, 8.0);
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(new ICoordinate[]{coordinate00, coordinate01});
        ILineString lineString = this.geometryFactory.createLineString(expectedCoordinateSequence);
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)lineString.getCoordinateSequence());
        Assertions.assertEquals((int)2, (int)lineString.getNumberOfCoordinates());
        Assertions.assertEquals((Object)coordinate00, (Object)lineString.getCoordinateN(0));
        Assertions.assertEquals((Object)coordinate01, (Object)lineString.getCoordinateN(1));
        Assertions.assertEquals((int)1, (int)lineString.getDimension());
        Assertions.assertEquals((Object)GeometryType.LINESTRING, (Object)lineString.getGeometryType());
        Assertions.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)lineString.getCoordinateReferenceSystem());
    }

    @Test
    public void testLinearRing() throws Exception {
        double[] xs = new double[]{50.0, 50.0, 100.0, 50.0};
        double[] ys = new double[]{50.0, 150.0, 100.0, 50.0};
        ICoordinateSequence expectedCoordinateSequence = this.coordinateSequenceFactory.create(xs, ys);
        ILinearRing linearRing = this.geometryFactory.createLinearRing(expectedCoordinateSequence);
        CoordinateSequenceAssert.assertEquals((ICoordinateSequence)expectedCoordinateSequence, (ICoordinateSequence)linearRing.getCoordinateSequence());
        Assertions.assertEquals((int)4, (int)linearRing.getNumberOfCoordinates());
        Assertions.assertEquals((Object)new Coordinate(xs[0], ys[0]), (Object)linearRing.getCoordinateN(0));
        Assertions.assertEquals((Object)new Coordinate(xs[1], ys[1]), (Object)linearRing.getCoordinateN(1));
        Assertions.assertEquals((Object)new Coordinate(xs[2], ys[2]), (Object)linearRing.getCoordinateN(2));
        Assertions.assertEquals((Object)new Coordinate(xs[3], ys[3]), (Object)linearRing.getCoordinateN(3));
        Assertions.assertEquals((int)1, (int)linearRing.getDimension());
        Assertions.assertEquals((Object)GeometryType.LINEARRING, (Object)linearRing.getGeometryType());
        Assertions.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)linearRing.getCoordinateReferenceSystem());
    }

    @Test
    public void testMultiLineString() throws Exception {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        IMultiLineString multiLineString = this.geometryFactory.createMultiLineString((double[][])xs, (double[][])ys);
        Assertions.assertEquals((int)2, (int)multiLineString.getNumberOfGeometries());
        Assertions.assertEquals((int)8, (int)multiLineString.getNumberOfCoordinates());
        Assertions.assertEquals((Object)new Coordinate(xs[0][0], ys[0][0]), (Object)multiLineString.getCoordinateN(0));
        Assertions.assertEquals((Object)new Coordinate(xs[0][1], ys[0][1]), (Object)multiLineString.getCoordinateN(1));
        Assertions.assertEquals((Object)new Coordinate(xs[0][2], ys[0][2]), (Object)multiLineString.getCoordinateN(2));
        Assertions.assertEquals((Object)new Coordinate(xs[0][3], ys[0][3]), (Object)multiLineString.getCoordinateN(3));
        Assertions.assertEquals((Object)new Coordinate(xs[1][0], ys[1][0]), (Object)multiLineString.getCoordinateN(4));
        Assertions.assertEquals((Object)new Coordinate(xs[1][1], ys[1][1]), (Object)multiLineString.getCoordinateN(5));
        Assertions.assertEquals((Object)new Coordinate(xs[1][2], ys[1][2]), (Object)multiLineString.getCoordinateN(6));
        Assertions.assertEquals((Object)new Coordinate(xs[1][3], ys[1][3]), (Object)multiLineString.getCoordinateN(7));
        Assertions.assertEquals((int)2, (int)multiLineString.getDimension());
        Assertions.assertEquals((int)2, (int)multiLineString.getCoordinateDimension());
        Assertions.assertEquals((Object)GeometryType.MULTILINESTRING, (Object)multiLineString.getGeometryType());
        Assertions.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)multiLineString.getCoordinateReferenceSystem());
    }

    @Test
    public void testMultiLineStringZ() throws Exception {
        double[][] xs = new double[][]{{50.0, 50.0, 150.0, 150.0}, {75.0, 75.0, 125.0, 125.0}};
        double[][] ys = new double[][]{{50.0, 150.0, 150.0, 50.0}, {75.0, 125.0, 125.0, 75.0}};
        double[][] zs = new double[][]{{30.0, 33.0, 31.0, 45.0}, {20.0, 22.0, 26.0, 28.0}};
        IMultiLineString multiLineString = this.geometryFactory.createMultiLineString((double[][])xs, (double[][])ys, (double[][])zs);
        Assertions.assertEquals((int)2, (int)multiLineString.getNumberOfGeometries());
        Assertions.assertEquals((int)8, (int)multiLineString.getNumberOfCoordinates());
        Assertions.assertEquals((Object)new Coordinate(xs[0][0], ys[0][0], zs[0][0], false), (Object)multiLineString.getCoordinateN(0));
        Assertions.assertEquals((Object)new Coordinate(xs[0][1], ys[0][1], zs[0][1], false), (Object)multiLineString.getCoordinateN(1));
        Assertions.assertEquals((Object)new Coordinate(xs[0][2], ys[0][2], zs[0][2], false), (Object)multiLineString.getCoordinateN(2));
        Assertions.assertEquals((Object)new Coordinate(xs[0][3], ys[0][3], zs[0][3], false), (Object)multiLineString.getCoordinateN(3));
        Assertions.assertEquals((Object)new Coordinate(xs[1][0], ys[1][0], zs[1][0], false), (Object)multiLineString.getCoordinateN(4));
        Assertions.assertEquals((Object)new Coordinate(xs[1][1], ys[1][1], zs[1][1], false), (Object)multiLineString.getCoordinateN(5));
        Assertions.assertEquals((Object)new Coordinate(xs[1][2], ys[1][2], zs[1][2], false), (Object)multiLineString.getCoordinateN(6));
        Assertions.assertEquals((Object)new Coordinate(xs[1][3], ys[1][3], zs[1][3], false), (Object)multiLineString.getCoordinateN(7));
        Assertions.assertEquals((int)2, (int)multiLineString.getDimension());
        Assertions.assertEquals((int)3, (int)multiLineString.getCoordinateDimension());
        Assertions.assertEquals((Object)GeometryType.MULTILINESTRING, (Object)multiLineString.getGeometryType());
        Assertions.assertEquals((Object)this.geometryFactory.getCoordinateReferenceSystem(), (Object)multiLineString.getCoordinateReferenceSystem());
    }

    @Test
    public void testGetTargetCoordianteReferenceSystem() {
        GeometryFactory factory = new GeometryFactory(ITestCoordinateReferenceSystem.GG_WGS_84);
        MatcherAssert.assertThat((Object)factory.getCoordinateReferenceSystem(), (Matcher)Matchers.equalTo((Object)ITestCoordinateReferenceSystem.GG_WGS_84));
        factory = new GeometryFactory(ITestCoordinateReferenceSystem.GG_WGS_84);
        MatcherAssert.assertThat((Object)factory.getCoordinateReferenceSystem(), (Matcher)Matchers.equalTo((Object)ITestCoordinateReferenceSystem.GG_WGS_84));
    }
}

