/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon;

import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.TestGeometryFactory;
import net.anwiba.spatial.geometry.polygon.ContainsLinearRingOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContainsLinearRingOperatorTest {
    @Test
    public void testCoordinate() throws Exception {
        ILinearRing ring = TestGeometryFactory.createLinearRing();
        ContainsLinearRingOperator operator = new ContainsLinearRingOperator(ring);
        Assertions.assertTrue((boolean)operator.contains((ICoordinate)new Coordinate(100.0, 60.0), false));
        Assertions.assertFalse((boolean)operator.contains((ICoordinate)new Coordinate(100.0, 40.0), false));
    }

    @Test
    public void testCoordinateMirrored() throws Exception {
        ILinearRing ring = TestGeometryFactory.createMirroredLinearRing();
        ContainsLinearRingOperator operator = new ContainsLinearRingOperator(ring);
        Assertions.assertTrue((boolean)operator.contains((ICoordinate)new Coordinate(60.0, 100.0), false));
        Assertions.assertFalse((boolean)operator.contains((ICoordinate)new Coordinate(40.0, 100.0), false));
    }

    @Test
    public void testRingContaints() throws Exception {
        ILinearRing ring = TestGeometryFactory.createShellLinearRing();
        ContainsLinearRingOperator operator = new ContainsLinearRingOperator(ring);
        Assertions.assertTrue((boolean)operator.contains((ILineString)TestGeometryFactory.createHoleLinearRing(), false));
    }

    @Test
    public void testRingContaintsNot() throws Exception {
        ILinearRing ring = TestGeometryFactory.createHoleLinearRing();
        ContainsLinearRingOperator operator = new ContainsLinearRingOperator(ring);
        Assertions.assertFalse((boolean)operator.contains((ILineString)TestGeometryFactory.createShellLinearRing(), false));
    }
}

