/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry;

import net.anwiba.spatial.geometry.IBaseGeometryTypeVisitor;

public enum BaseGeometryType {
    POINT{

        @Override
        public <T, E extends Exception> T accept(IBaseGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitPoint();
        }

        @Override
        public int getMinimumCountOfLineSignatures() {
            return 0;
        }
    }
    ,
    CURVE{

        @Override
        public <T, E extends Exception> T accept(IBaseGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitCurve();
        }

        @Override
        public int getMinimumCountOfLineSignatures() {
            return 1;
        }
    }
    ,
    POLYGON{

        @Override
        public <T, E extends Exception> T accept(IBaseGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitPolygon();
        }

        @Override
        public int getMinimumCountOfLineSignatures() {
            return 0;
        }
    }
    ,
    UNKNOWN{

        @Override
        public <T, E extends Exception> T accept(IBaseGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnknown();
        }

        @Override
        public int getMinimumCountOfLineSignatures() {
            return 1;
        }
    };


    public abstract <T, E extends Exception> T accept(IBaseGeometryTypeVisitor<T, E> var1) throws E;

    public abstract int getMinimumCountOfLineSignatures();
}

