/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.calculator;

import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.calculator.InteriorCalculator;

public class GeometryCalculator {
    public static IEnvelope createEnvelope(IGeometry[] geometries) {
        IEnvelope envelope = Envelope.NULL_ENVELOPE;
        for (IGeometry geometry : geometries) {
            envelope = envelope.concat(geometry.getEnvelope());
        }
        return envelope;
    }

    public static double calculateLength(IGeometry geometry) {
        if (geometry == null) {
            return 0.0;
        }
        if (geometry.isCollection()) {
            IGeometryCollection collection = (IGeometryCollection)geometry;
            double sum = 0.0;
            for (int i = 0; i < collection.getNumberOfGeometries(); ++i) {
                sum += GeometryCalculator.calculateLength(collection.getGeometryN(i));
            }
            return sum;
        }
        if (geometry.getGeometryType() == GeometryType.POLYGON) {
            IPolygon polygon = (IPolygon)geometry;
            double sum = CoordinateUtilities.calculateLength((ICoordinateSequence)polygon.getOuterRing().getCoordinateSequence());
            for (int i = 0; i < polygon.getNumberOfInnerRings(); ++i) {
                sum += CoordinateUtilities.calculateLength((ICoordinateSequence)polygon.getInnerRingN(i).getCoordinateSequence());
            }
            return sum;
        }
        return CoordinateUtilities.calculateLength((ICoordinateSequence)geometry.getCoordinateSequence());
    }

    public static ICoordinate calculateInterior(IGeometry geometry) {
        return InteriorCalculator.calculateInterior(geometry);
    }

    public static ICoordinate calculateCentroid(IGeometry geometry) {
        return CoordinateSequenceUtilities.calculateCentroid((ICoordinateSequence)geometry.getCoordinateSequence());
    }

    public static double calculateArea(IGeometry geometry) {
        if (geometry == null) {
            return 0.0;
        }
        if (geometry.isCollection()) {
            IGeometryCollection collection = (IGeometryCollection)geometry;
            double sum = 0.0;
            for (int i = 0; i < collection.getNumberOfGeometries(); ++i) {
                sum += GeometryCalculator.calculateArea(collection.getGeometryN(i));
            }
            return sum;
        }
        if (geometry.getGeometryType() == GeometryType.POLYGON) {
            IPolygon polygon = (IPolygon)geometry;
            double area = CoordinateUtilities.calculateArea((ICoordinateSequence)polygon.getOuterRing().getCoordinateSequence());
            for (int i = 0; i < polygon.getNumberOfInnerRings(); ++i) {
                area -= CoordinateUtilities.calculateArea((ICoordinateSequence)polygon.getInnerRingN(i).getCoordinateSequence());
            }
            return area;
        }
        return 0.0;
    }
}

