/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.extract;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.extract.ICoordinateExtractor;
import net.anwiba.spatial.geometry.extract.ICoordinateReference;
import net.anwiba.spatial.geometry.extract.IPath;
import net.anwiba.spatial.geometry.extract.IStep;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;

public class CoordinateExtractor
implements ICoordinateExtractor {
    private final IGeometry geometry;

    public CoordinateExtractor(IGeometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public ICoordinate extract(ICoordinateReference reference) {
        IPath path = reference.getPath();
        if (!path.hasStep()) {
            return null;
        }
        return this.extract(this.geometry, path.getStep());
    }

    private ICoordinate extract(IGeometry geometry, IStep step) {
        if (step.hasNext()) {
            this.extract(GeometryUtilities.extract(geometry, step.getIndex()), step.next());
        }
        return geometry.getCoordinateN(step.getIndex());
    }
}

