/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.IBaseGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.calculator.GeometryCalculator;
import net.anwiba.spatial.geometry.internal.AbstractGeometry;

public abstract class AbstractGeometryCollection<T extends IBaseGeometry>
extends AbstractGeometry
implements IGeometryCollection {
    private static final long serialVersionUID = 1498634025534697222L;
    private final List<T> geometries = new ArrayList<T>();
    private ICoordinateSequence sequence;

    AbstractGeometryCollection(ICoordinateReferenceSystem coordinateReferenceSystem, T[] geometries) {
        super(coordinateReferenceSystem, 2, GeometryCalculator.createEnvelope(geometries));
        for (T geometry : geometries) {
            this.geometries.add(geometry);
        }
    }

    @Override
    public int getCoordinateDimension() {
        if (this.geometries.size() == 0) {
            return 2;
        }
        return ((IBaseGeometry)this.geometries.get(0)).getCoordinateDimension();
    }

    @Override
    public boolean isMeasured() {
        for (IBaseGeometry geometry : this.geometries) {
            if (!geometry.isMeasured()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICoordinateSequence getCoordinateSequence() {
        if (this.sequence == null) {
            ICoordinateSequence sequence = null;
            for (IBaseGeometry geometry : this.geometries) {
                sequence = CoordinateSequenceUtilities.concat(sequence, (ICoordinateSequence)geometry.getCoordinateSequence());
            }
            this.sequence = sequence;
        }
        return this.sequence;
    }

    public T getGeometryN(int index) {
        return (T)((IBaseGeometry)this.geometries.get(index));
    }

    public Iterable<T> geometries() {
        return this.geometries;
    }

    @Override
    public int getNumberOfGeometries() {
        return this.geometries.size();
    }
}

