/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import net.anwiba.spatial.coordinate.Envelope;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.ILineSegment;

public class LineSegment
implements ILineSegment {
    private final ICoordinate startPoint;
    private final ICoordinate endPoint;

    public LineSegment(ICoordinate startPoint, ICoordinate endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    @Override
    public ICoordinate getStartPoint() {
        return this.startPoint;
    }

    @Override
    public ICoordinate getEndPoint() {
        return this.endPoint;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean cordinateFlag = false;
        boolean ordinateFlag = false;
        for (ICoordinate coordinate : new ICoordinate[]{this.startPoint, this.endPoint}) {
            if (cordinateFlag) {
                buffer.append("; ");
            }
            cordinateFlag = true;
            double[] values = coordinate.getValues();
            ordinateFlag = false;
            for (double value : values) {
                if (ordinateFlag) {
                    buffer.append(", ");
                }
                ordinateFlag = true;
                buffer.append(value);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public IEnvelope getEnvelope() {
        return new Envelope(new double[]{Math.min(this.startPoint.getXValue(), this.endPoint.getXValue()), Math.min(this.startPoint.getYValue(), this.endPoint.getYValue())}, new double[]{Math.max(this.startPoint.getXValue(), this.endPoint.getXValue()), Math.max(this.startPoint.getYValue(), this.endPoint.getYValue())}, false);
    }
}

