/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.spatial.geometry.operator.IEnvelopeConverter;
import org.khelekore.prtree.MBR;
import org.khelekore.prtree.MBRConverter;
import org.khelekore.prtree.PRTree;

public class Rtree<T> {
    List<T> objects = new ArrayList<T>();
    private MBRConverter<T> mbrConverter;
    private PRTree<T> tree;

    public Rtree(final IEnvelopeConverter<T> converter) {
        this.mbrConverter = new MBRConverter<T>(){

            public int getDimensions() {
                return converter.getDimensions();
            }

            public double getMin(int axis, T t) {
                return converter.getMin(axis, t);
            }

            public double getMax(int axis, T t) {
                return converter.getMax(axis, t);
            }
        };
        this.tree = new PRTree(this.mbrConverter, 10);
    }

    public List<T> query(double startValue, double endValue) {
        Iterable iterable = this.tree.find((MBR)new Mbr(startValue, endValue));
        return IterableUtilities.asList((Iterable)iterable);
    }

    public List<T> query(double value) {
        Iterable iterable = this.tree.find((MBR)new Mbr(value, value));
        List list = IterableUtilities.asList((Iterable)iterable);
        return list;
    }

    public void insert(T object) {
        this.objects.add(object);
    }

    public void build() {
        this.tree.load(this.objects);
    }

    public static class Mbr
    implements MBR {
        private final double startValue;
        private final double endValue;

        public Mbr(double startValue, double endValue) {
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public MBR union(MBR mbr) {
            return new Mbr(Math.min(mbr.getMin(0), this.getMin(0)), Math.min(mbr.getMax(0), this.getMax(0)));
        }

        public <T> boolean intersects(T other, MBRConverter<T> converter) {
            if (other == null) {
                return false;
            }
            return this.intersects(converter.getMin(0, other), converter.getMax(0, other));
        }

        public boolean intersects(MBR other) {
            if (other == null) {
                return false;
            }
            return this.intersects(other.getMin(0), other.getMax(0));
        }

        private boolean intersects(double otherMin, double otherMax) {
            boolean intersects = !(otherMin > this.getMax(0)) && !(otherMax < this.getMin(0));
            return intersects;
        }

        public double getMin(int axis) {
            return Math.min(this.startValue, this.endValue);
        }

        public double getMax(int axis) {
            return Math.max(this.startValue, this.endValue);
        }

        public int getDimensions() {
            return 1;
        }
    }
}

