/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry;

import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.spatial.geometry.BaseGeometryType;
import net.anwiba.spatial.geometry.IGeometryTypeVisitor;

public enum GeometryType {
    POINT(BaseGeometryType.POINT, false){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitPoint();
        }
    }
    ,
    LINESTRING(BaseGeometryType.CURVE, false){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitLineString();
        }
    }
    ,
    LINEARRING(BaseGeometryType.CURVE, false){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitLinearRing();
        }
    }
    ,
    POLYGON(BaseGeometryType.POLYGON, false){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitPolygon();
        }
    }
    ,
    MULTIPOINT(BaseGeometryType.POINT, true){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitMultiPoint();
        }
    }
    ,
    MULTILINESTRING(BaseGeometryType.CURVE, true){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitMultiLineString();
        }
    }
    ,
    MULTIPOLYGON(BaseGeometryType.POLYGON, true){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitMultiPolygon();
        }
    }
    ,
    COLLECTION(BaseGeometryType.UNKNOWN, true){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitCollection();
        }
    }
    ,
    UNKNOWN(BaseGeometryType.UNKNOWN, true){

        @Override
        public <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> visitor) throws E {
            return visitor.visitUnknown();
        }
    };

    private final BaseGeometryType baseType;
    private final boolean isCollection;

    private GeometryType(BaseGeometryType baseType, boolean isCollection) {
        this.baseType = baseType;
        this.isCollection = isCollection;
    }

    public BaseGeometryType getBaseGeometryType() {
        return this.baseType;
    }

    public abstract <T, E extends Exception> T accept(IGeometryTypeVisitor<T, E> var1) throws E;

    public boolean isCollection() {
        return this.isCollection;
    }

    public static GeometryType getByName(String name) {
        GeometryType[] values;
        for (GeometryType value : values = GeometryType.values()) {
            if (!StringUtilities.equalsIgnoreCase((String)name, (String)value.name())) continue;
            return value;
        }
        if (StringUtilities.equalsIgnoreCase((String)name, (String)"geometrycollection")) {
            return COLLECTION;
        }
        return UNKNOWN;
    }
}

