/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import java.util.Objects;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.IGeometry;

public abstract class AbstractGeometry
implements IGeometry {
    private static final long serialVersionUID = -106165025117947056L;
    private final IEnvelope envelope;
    private final ICoordinateReferenceSystem coordinateReferenceSystem;
    private final int dimension;

    AbstractGeometry(ICoordinateReferenceSystem coordinateReferenceSystem, int dimension, IEnvelope envelope) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
        this.dimension = dimension;
        this.envelope = envelope;
    }

    protected void ensure(ICoordinateSequence sequence) {
        if (sequence.getDimension() < this.getDimension()) {
            throw new IllegalArgumentException("Coordinate dimension (" + sequence.getDimension() + ") is to small for a " + this.getGeometryType().name());
        }
    }

    @Override
    public final ICoordinate getCoordinateN(int index) {
        return this.getCoordinateSequence().getCoordinateN(index);
    }

    @Override
    public abstract ICoordinateSequence getCoordinateSequence();

    @Override
    public final int getDimension() {
        return this.dimension;
    }

    @Override
    public IEnvelope getEnvelope() {
        return this.envelope;
    }

    @Override
    public ICoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    @Override
    public abstract GeometryType getGeometryType();

    @Override
    public final int getNumberOfCoordinates() {
        return this.getCoordinateSequence().getNumberOfCoordinates();
    }

    @Override
    public boolean isMeasured() {
        return this.getCoordinateSequence().isMeasured();
    }

    @Override
    public final boolean isCollection() {
        return this.getGeometryType().isCollection();
    }

    public int hashCode() {
        return Objects.hash(this.coordinateReferenceSystem, this.dimension, this.envelope);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeometry other = (AbstractGeometry)obj;
        return Objects.equals(this.coordinateReferenceSystem, other.coordinateReferenceSystem) && this.dimension == other.dimension && Objects.equals(this.envelope, other.envelope);
    }
}

