/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.spatial.coordinate.Coordinate;
import net.anwiba.spatial.coordinate.CoordinateSequence;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.ICoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.coordinate.calculator.CoordinateSequenceOrientationCalculator;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.IBaseGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.IMultiPoint;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.IRectangle;
import net.anwiba.spatial.geometry.internal.GeometryCollection;
import net.anwiba.spatial.geometry.internal.LineString;
import net.anwiba.spatial.geometry.internal.LinearRing;
import net.anwiba.spatial.geometry.internal.MultiLineString;
import net.anwiba.spatial.geometry.internal.MultiPoint;
import net.anwiba.spatial.geometry.internal.MultiPolygon;
import net.anwiba.spatial.geometry.internal.Point;
import net.anwiba.spatial.geometry.internal.Polygon;
import net.anwiba.spatial.geometry.internal.Rectangle;

public class GeometryFactory
implements IGeometryFactory {
    private static final long serialVersionUID = -7130012312884204195L;
    private static ILogger logger = Logging.getLogger((String)GeometryFactory.class.getName());
    private final ICoordinateReferenceSystem coordianteReferenceSystem;
    private final ICoordinateSequenceFactory coordinateSequenceFactory = new CoordinateSequenceFactory();

    public GeometryFactory(ICoordinateReferenceSystem coordianteReferenceSystem) {
        this.coordianteReferenceSystem = coordianteReferenceSystem;
    }

    @Override
    public IPoint createPoint(Number x, Number y) {
        return this.createPoint((ICoordinate)new Coordinate(((Double)Optional.of((Object)x).convert(v -> v.doubleValue()).getOr(() -> Double.NaN)).doubleValue(), ((Double)Optional.of((Object)y).convert(v -> v.doubleValue()).getOr(() -> Double.NaN)).doubleValue()));
    }

    @Override
    public IPoint createPoint(double x, double y) {
        return this.createPoint((ICoordinate)new Coordinate(x, y));
    }

    @Override
    public IPoint createPoint(ICoordinate coordinate) {
        return this.createPoint(coordinate, new CoordinateSequenceFactory().create(new ICoordinate[]{coordinate}).getEnvelope());
    }

    @Override
    public IPoint createPoint(ICoordinate coordinate, IEnvelope envelope) {
        return new Point(this.getCoordinateReferenceSystem(), coordinate, envelope);
    }

    @Override
    public ILineString createLineString(double[] xs, double[] ys) {
        return new LineString(this.getCoordinateReferenceSystem(), this.coordinateSequenceFactory.create(xs, ys));
    }

    @Override
    public ILineString createLineString(ICoordinateSequence coordinateSequence) {
        return new LineString(this.getCoordinateReferenceSystem(), coordinateSequence);
    }

    @Override
    public ILinearRing createLinearRing(double[] xs, double[] ys) {
        return this.createLinearRing(this.coordinateSequenceFactory.create(xs, ys));
    }

    @Override
    public ILinearRing createLinearRing(ICoordinateSequence sequence) {
        if (!sequence.isClosed() && sequence.getNumberOfCoordinates() > 2) {
            logger.log(ILevel.WARNING, "Unclosed coordinate sequence for linear ring");
            return new LinearRing(this.getCoordinateReferenceSystem(), CoordinateSequenceUtilities.concat((ICoordinateSequence)sequence, (ICoordinate)sequence.getCoordinateN(0)), CoordinateSequenceOrientationCalculator.getOrientation((ICoordinateSequence)sequence));
        }
        return new LinearRing(this.getCoordinateReferenceSystem(), sequence, CoordinateSequenceOrientationCalculator.getOrientation((ICoordinateSequence)sequence));
    }

    @Override
    public IPolygon createPolygon(double[] xs, double[] ys) {
        return this.createPolygon(this.coordinateSequenceFactory.create(xs, ys), (ICoordinateSequence[])new CoordinateSequence[0]);
    }

    @Override
    public IPolygon createPolygon(ICoordinateSequence coordinateSequence) {
        return this.createPolygon(coordinateSequence, new ICoordinateSequence[0]);
    }

    @Override
    public IPolygon createPolygon(double[] xs, double[] ys, double[][] hxs, double[][] hys) {
        ICoordinateSequence[] coordinateSequences = new ICoordinateSequence[hxs.length];
        for (int i = 0; i < coordinateSequences.length; ++i) {
            coordinateSequences[i] = this.coordinateSequenceFactory.create(hxs[i], hys[i]);
        }
        return this.createPolygon(this.coordinateSequenceFactory.create(xs, ys), coordinateSequences);
    }

    @Override
    public IPolygon createPolygon(ICoordinateSequence sequence, ICoordinateSequence[] sequences) {
        ILinearRing outerRing = this.createLinearRing(sequence);
        ArrayList<ILinearRing> innerRings = new ArrayList<ILinearRing>();
        for (ICoordinateSequence coordinateSequence : sequences) {
            innerRings.add(this.createLinearRing(coordinateSequence));
        }
        return this.createPolygon(outerRing, innerRings.toArray(new ILinearRing[innerRings.size()]));
    }

    @Override
    public IPolygon createPolygon(ILinearRing outerRing, List<ILinearRing> innerRings) {
        return this.createPolygon(outerRing, (ILinearRing[])innerRings.stream().toArray(ILinearRing[]::new));
    }

    @Override
    public Polygon createPolygon(ILinearRing outerRing, ILinearRing[] innerRings) {
        if (innerRings == null) {
            return new Polygon(this.getCoordinateReferenceSystem(), outerRing);
        }
        return new Polygon(this.getCoordinateReferenceSystem(), outerRing, innerRings);
    }

    @Override
    public IMultiPoint createMultiPoint(double[] xs, double[] ys) {
        return this.createMultiPoint(this.coordinateSequenceFactory.create(xs, ys));
    }

    @Override
    public IMultiPoint createMultiPoint(IPoint point) {
        return new MultiPoint(this.getCoordinateReferenceSystem(), new IPoint[]{point});
    }

    @Override
    public IMultiPoint createMultiPoint(IPoint[] points) {
        return new MultiPoint(this.getCoordinateReferenceSystem(), points);
    }

    @Override
    public IMultiPoint createMultiPoint(List<IPoint> points) {
        return new MultiPoint(this.getCoordinateReferenceSystem(), (IPoint[])points.toArray(IPoint[]::new));
    }

    @Override
    public IMultiPoint createMultiPoint(ICoordinateSequence coordinateSequence) {
        ICoordinate[] coordinates = CoordinateUtilities.getCoordinates((ICoordinateSequence)coordinateSequence);
        ArrayList<IPoint> points = new ArrayList<IPoint>();
        for (ICoordinate coordinate : coordinates) {
            points.add(this.createPoint(coordinate));
        }
        return new MultiPoint(this.getCoordinateReferenceSystem(), points.toArray(new IPoint[points.size()]));
    }

    @Override
    public IMultiLineString createMultiLineString(double[][] xs, double[][] ys) {
        ICoordinateSequence[] coordinateSequences = new ICoordinateSequence[xs.length];
        for (int i = 0; i < coordinateSequences.length; ++i) {
            coordinateSequences[i] = this.coordinateSequenceFactory.create(xs[i], ys[i]);
        }
        return this.createMultiLineString(coordinateSequences);
    }

    @Override
    public IMultiLineString createMultiLineString(double[][] xs, double[][] ys, double[][] zs) {
        return this.createMultiLineString(xs, ys, zs, false);
    }

    @Override
    public IMultiLineString createMultiLineString(double[][] xs, double[][] ys, double[][] zs, boolean isMesured) {
        ICoordinateSequence[] coordinateSequences = new ICoordinateSequence[xs.length];
        for (int i = 0; i < coordinateSequences.length; ++i) {
            coordinateSequences[i] = this.coordinateSequenceFactory.create(xs[i], ys[i], zs[i], isMesured);
        }
        return this.createMultiLineString(coordinateSequences);
    }

    @Override
    public IMultiLineString createMultiLineString(double[][] xs, double[][] ys, double[][] zs, double[][] ms) {
        ICoordinateSequence[] coordinateSequences = new ICoordinateSequence[xs.length];
        for (int i = 0; i < coordinateSequences.length; ++i) {
            coordinateSequences[i] = this.coordinateSequenceFactory.create(xs[i], ys[i], zs[i], ms[i]);
        }
        return this.createMultiLineString(coordinateSequences);
    }

    @Override
    public IMultiLineString createMultiLineString(ICoordinateSequence[] coordinateSequences) {
        ArrayList<ILineString> lineStrings = new ArrayList<ILineString>();
        for (ICoordinateSequence sequence : coordinateSequences) {
            lineStrings.add(this.createLineString(sequence));
        }
        return this.createMultiLineString(lineStrings.toArray(new ILineString[lineStrings.size()]));
    }

    @Override
    public IMultiLineString createMultiLineString(ILineString lineStrings) {
        return new MultiLineString(this.getCoordinateReferenceSystem(), new ILineString[]{lineStrings});
    }

    @Override
    public IMultiLineString createMultiLineString(List<ILineString> lineStrings) {
        return new MultiLineString(this.getCoordinateReferenceSystem(), (ILineString[])lineStrings.toArray(ILineString[]::new));
    }

    @Override
    public IMultiLineString createMultiLineString(ILineString[] lineStrings) {
        return new MultiLineString(this.getCoordinateReferenceSystem(), lineStrings);
    }

    @Override
    public IMultiPolygon createMultiPolygon(double[][] xs, double[][] ys) {
        ICoordinateSequence[] coordinateSequences = new ICoordinateSequence[xs.length];
        for (int i = 0; i < coordinateSequences.length; ++i) {
            coordinateSequences[i] = this.coordinateSequenceFactory.create(xs[i], ys[i]);
        }
        return this.createMultiPolygon(coordinateSequences);
    }

    private IMultiPolygon createMultiPolygon(ICoordinateSequence[] outerRingSequences) {
        ArrayList<IPolygon> polygons = new ArrayList<IPolygon>();
        for (ICoordinateSequence sequence : outerRingSequences) {
            polygons.add(this.createPolygon(sequence));
        }
        return new MultiPolygon(this.getCoordinateReferenceSystem(), polygons.toArray(new IPolygon[polygons.size()]));
    }

    @Override
    public IMultiPolygon createMultiPolygon(double[][] xs, double[][] ys, double[][][] hxs, double[][][] hys) {
        ICoordinateSequence[] outerRingSequences = new ICoordinateSequence[xs.length];
        for (int i = 0; i < outerRingSequences.length; ++i) {
            outerRingSequences[i] = this.coordinateSequenceFactory.create(xs[i], ys[i]);
        }
        ICoordinateSequence[][] innerRingSequences = new ICoordinateSequence[hxs.length][];
        for (int i = 0; i < innerRingSequences.length; ++i) {
            innerRingSequences[i] = new ICoordinateSequence[hxs[i].length];
            for (int j = 0; j < innerRingSequences[i].length; ++j) {
                innerRingSequences[i][j] = this.coordinateSequenceFactory.create(hxs[i][j], hys[i][j]);
            }
        }
        return this.createMultiPolygon(outerRingSequences, innerRingSequences);
    }

    @Override
    public IMultiPolygon createMultiPolygon(ICoordinateSequence[] outerRingSequences, ICoordinateSequence[][] innerRingSequences) {
        ArrayList<ILinearRing> outerRings = new ArrayList<ILinearRing>();
        ArrayList<ILinearRing[]> innerRings = new ArrayList<ILinearRing[]>();
        for (int i = 0; i < outerRingSequences.length; ++i) {
            outerRings.add(this.createLinearRing(outerRingSequences[i]));
            ArrayList<ILinearRing> rings = new ArrayList<ILinearRing>();
            for (int j = 0; j < innerRingSequences[i].length; ++j) {
                rings.add(this.createLinearRing(innerRingSequences[i][j]));
            }
            innerRings.add(rings.toArray(new LinearRing[rings.size()]));
        }
        return this.createMultiPolygon(outerRings.toArray(new LinearRing[outerRings.size()]), (ILinearRing[][])innerRings.toArray((T[])new ILinearRing[innerRings.size()][]));
    }

    private IMultiPolygon createMultiPolygon(ILinearRing[] outerRings, ILinearRing[][] innerRings) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < outerRings.length; ++i) {
            polygons.add(this.createPolygon(outerRings[i], innerRings[i]));
        }
        return new MultiPolygon(this.getCoordinateReferenceSystem(), polygons.toArray(new IPolygon[polygons.size()]));
    }

    @Override
    public IMultiPolygon createMultiPolygon(IPolygon polygon) {
        return new MultiPolygon(this.getCoordinateReferenceSystem(), new IPolygon[]{polygon});
    }

    @Override
    public IMultiPolygon createMultiPolygon(IPolygon[] polygons) {
        return new MultiPolygon(this.getCoordinateReferenceSystem(), polygons);
    }

    @Override
    public IMultiPolygon createMultiPolygon(List<IPolygon> polygons) {
        return new MultiPolygon(this.getCoordinateReferenceSystem(), (IPolygon[])polygons.stream().toArray(IPolygon[]::new));
    }

    @Override
    public IGeometryCollection createCollection(IBaseGeometry[] geometries) {
        return new GeometryCollection(this.getCoordinateReferenceSystem(), geometries);
    }

    @Override
    public IGeometryCollection createCollection(List<IBaseGeometry> geometries) {
        return new GeometryCollection(this.getCoordinateReferenceSystem(), (IBaseGeometry[])geometries.toArray(IBaseGeometry[]::new));
    }

    @Override
    public IPolygon createPolygon(IEnvelope envelope) {
        return this.createRectangle(envelope);
    }

    @Override
    public IRectangle createRectangle(IEnvelope envelope) {
        return new Rectangle(this.coordianteReferenceSystem, envelope);
    }

    @Override
    public ICoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.coordinateSequenceFactory;
    }

    @Override
    public ICoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordianteReferenceSystem;
    }
}

