/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import java.util.Objects;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.internal.AbstractGeometry;

public class LineString
extends AbstractGeometry
implements ILineString {
    private static final long serialVersionUID = -8726599134630191264L;
    final ICoordinateSequence coordinateSequence;

    LineString(ICoordinateReferenceSystem coordinateReferenceSystem, ICoordinateSequence coordinateSequence) {
        super(coordinateReferenceSystem, 1, coordinateSequence.getEnvelope());
        this.ensure(coordinateSequence);
        this.coordinateSequence = coordinateSequence;
    }

    @Override
    protected void ensure(ICoordinateSequence sequence) {
        super.ensure(sequence);
        if (sequence.getNumberOfCoordinates() < 2) {
            throw new IllegalArgumentException("Linestring needs more than one coordinates");
        }
    }

    @Override
    public int getCoordinateDimension() {
        return this.coordinateSequence.getDimension();
    }

    @Override
    public ICoordinateSequence getCoordinateSequence() {
        return this.coordinateSequence;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINESTRING;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.coordinateSequence);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineString other = (LineString)obj;
        return Objects.equals(this.coordinateSequence, other.coordinateSequence);
    }
}

