/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import java.util.Objects;
import net.anwiba.commons.ensure.Conditions;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.ensure.ICondition;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.Orientation;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.internal.LineString;

public class LinearRing
extends LineString
implements ILinearRing {
    private static final long serialVersionUID = -6728378856953023848L;
    private final Orientation orientation;

    LinearRing(ICoordinateReferenceSystem coordinateReferenceSystem, ICoordinateSequence coordinateSequence, Orientation orientation) {
        super(coordinateReferenceSystem, coordinateSequence);
        Ensure.ensureThat((Object)orientation, (ICondition)Conditions.notNull());
        this.orientation = orientation;
    }

    @Override
    protected void ensure(ICoordinateSequence sequence) {
        super.ensure(sequence);
        int coordinateCount = sequence.getNumberOfCoordinates();
        if (coordinateCount < 4) {
            throw new IllegalArgumentException("Linearring needs more than two different coordinates");
        }
        if (!sequence.isClosed()) {
            throw new IllegalArgumentException("first and last coordinare must be equal for Linearrings");
        }
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINEARRING;
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.orientation);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinearRing other = (LinearRing)obj;
        return this.orientation == other.orientation;
    }
}

