/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.internal.AbstractGeometry;

public class Point
extends AbstractGeometry
implements IPoint {
    private static final long serialVersionUID = -3618728196988091583L;
    private final ICoordinate coordinate;

    public Point(ICoordinateReferenceSystem coordinateReferenceSystem, ICoordinate coordinate) {
        this(coordinateReferenceSystem, coordinate, new CoordinateSequenceFactory().create(new ICoordinate[]{coordinate}).getEnvelope());
    }

    public Point(ICoordinateReferenceSystem coordinateReferenceSystem, ICoordinate coordinate, IEnvelope envelope) {
        super(coordinateReferenceSystem, 0, envelope);
        this.coordinate = coordinate;
    }

    @Override
    public int getCoordinateDimension() {
        return this.coordinate.getDimension();
    }

    @Override
    public ICoordinateSequence getCoordinateSequence() {
        return new CoordinateSequenceFactory().create(new ICoordinate[]{this.coordinate});
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POINT;
    }

    @Override
    public ICoordinate getCoordinate() {
        return this.coordinate;
    }
}

