/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.internal;

import java.util.Arrays;
import java.util.Objects;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.GeometryType;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.internal.AbstractGeometry;
import net.anwiba.spatial.geometry.internal.LinearRing;

public class Polygon
extends AbstractGeometry
implements IPolygon {
    private static final long serialVersionUID = 5918310084074735053L;
    private final ILinearRing[] innerRings;
    private final ILinearRing outerRing;

    Polygon(ICoordinateReferenceSystem coordinateReferenceSystem, ILinearRing outerRing) {
        this(coordinateReferenceSystem, outerRing, new LinearRing[0]);
    }

    Polygon(ICoordinateReferenceSystem coordinateReferenceSystem, ILinearRing outerRing, ILinearRing[] innerRings) {
        super(coordinateReferenceSystem, 2, outerRing.getEnvelope());
        this.outerRing = outerRing;
        this.innerRings = innerRings;
    }

    @Override
    public int getCoordinateDimension() {
        return this.outerRing.getCoordinateDimension();
    }

    @Override
    public ICoordinateSequence getCoordinateSequence() {
        ICoordinateSequence sequence = this.outerRing.getCoordinateSequence();
        for (ILinearRing innerRing : this.innerRings) {
            sequence = CoordinateSequenceUtilities.concat((ICoordinateSequence)sequence, (ICoordinateSequence)innerRing.getCoordinateSequence());
        }
        return sequence;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POLYGON;
    }

    @Override
    public ILinearRing getInnerRingN(int index) {
        return this.innerRings[index];
    }

    @Override
    public int getNumberOfInnerRings() {
        return this.innerRings.length;
    }

    @Override
    public ILinearRing getOuterRing() {
        return this.outerRing;
    }

    @Override
    public Iterable<ILinearRing> getInnerRings() {
        return Arrays.asList(this.innerRings);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.innerRings);
        result = 31 * result + Objects.hash(this.outerRing);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        return Arrays.equals(this.innerRings, other.innerRings) && Objects.equals(this.outerRing, other.outerRing);
    }
}

