/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.spatial.coordinate.CoordinateCalculationException;
import net.anwiba.spatial.coordinate.CoordinateSequence;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.IGeometryTypeVisitor;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.IMultiLineString;
import net.anwiba.spatial.geometry.utilities.GeometryUtilities;

public class EnvelopeIntersectOperator {
    final IEnvelope envelope;

    public EnvelopeIntersectOperator(IEnvelope envelope) {
        this.envelope = envelope;
    }

    public IGeometry intersect(final IGeometry geometry) {
        if (this.envelope.contains(geometry.getEnvelope())) {
            return geometry;
        }
        if (!this.envelope.interact(geometry.getEnvelope())) {
            return null;
        }
        final IGeometryFactory geometryFactory = GeometryUtilities.getGeometryFactory(geometry.getCoordinateReferenceSystem());
        IGeometryTypeVisitor<IGeometry, RuntimeException> visitor = new IGeometryTypeVisitor<IGeometry, RuntimeException>(){

            @Override
            public IGeometry visitUnknown() throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public IGeometry visitPolygon() throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public IGeometry visitPoint() throws RuntimeException {
                if (EnvelopeIntersectOperator.this.envelope.interact(geometry.getCoordinateN(0))) {
                    return geometry;
                }
                return null;
            }

            @Override
            public IGeometry visitMultiPolygon() throws RuntimeException {
                throw new UnsupportedOperationException();
            }

            @Override
            public IGeometry visitMultiPoint() throws RuntimeException {
                ICoordinateSequence sequence = EnvelopeIntersectOperator.this.getInteractingCoordinateSequence(geometry.getCoordinateSequence());
                if (sequence.getNumberOfCoordinates() == 0) {
                    return null;
                }
                return GeometryUtilities.getGeometryFactory(geometry.getCoordinateReferenceSystem()).createMultiPoint(sequence);
            }

            @Override
            public IGeometry visitMultiLineString() throws RuntimeException {
                IMultiLineString multiLineString = (IMultiLineString)geometry;
                ArrayList<ICoordinateSequence> sequences = new ArrayList<ICoordinateSequence>();
                for (int i = 0; i < multiLineString.getNumberOfGeometries(); ++i) {
                    ILineString part = multiLineString.getGeometryN(i);
                    ICoordinateSequence sequence = EnvelopeIntersectOperator.this.getInteractingCoordinateSequence(part.getCoordinateSequence());
                    if (sequence.getNumberOfCoordinates() <= 1) continue;
                    sequences.add(sequence);
                }
                if (sequences.isEmpty()) {
                    return null;
                }
                return geometryFactory.createMultiLineString((ICoordinateSequence[])sequences.toArray(new CoordinateSequence[sequences.size()]));
            }

            @Override
            public IGeometry visitLinearRing() throws RuntimeException {
                ICoordinateSequence sequence = EnvelopeIntersectOperator.this.getInteractingSegmentCoordinateSequence(geometry.getCoordinateSequence());
                if (sequence.getNumberOfCoordinates() == 0) {
                    return null;
                }
                if (sequence.getNumberOfCoordinates() > 2 && sequence.isClosed()) {
                    return geometryFactory.createLinearRing(sequence);
                }
                return geometryFactory.createLineString(sequence);
            }

            @Override
            public IGeometry visitLineString() throws RuntimeException {
                ICoordinateSequence sequence = EnvelopeIntersectOperator.this.getInteractingSegmentCoordinateSequence(geometry.getCoordinateSequence());
                if (sequence.getNumberOfCoordinates() == 0) {
                    return null;
                }
                if (sequence.getNumberOfCoordinates() == 1) {
                    return null;
                }
                return geometryFactory.createLineString(sequence);
            }

            @Override
            public IGeometry visitCollection() throws RuntimeException {
                throw new UnsupportedOperationException();
            }
        };
        return geometry.getGeometryType().accept(visitor);
    }

    protected ICoordinateSequence getInteractingSegmentCoordinateSequence(ICoordinateSequence sequence) {
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        ICoordinate prior = null;
        boolean isPriorInteracting = false;
        for (ICoordinate next : sequence.getCoordinates()) {
            boolean isNextInteracting = this.envelope.interact(next);
            if (prior == null) {
                if (isNextInteracting) {
                    coordinates.add(next);
                }
                isPriorInteracting = isNextInteracting;
                prior = next;
                continue;
            }
            if (prior.touch(next)) {
                prior = next;
                continue;
            }
            if (!isNextInteracting || !isPriorInteracting) {
                coordinates.addAll(this.getCrossingCoordinats(prior, next));
            }
            if (isNextInteracting && !coordinates.contains(next)) {
                coordinates.add(next);
            }
            isPriorInteracting = isNextInteracting;
            prior = next;
        }
        return new CoordinateSequenceFactory().create(coordinates);
    }

    private List<ICoordinate> getCrossingCoordinats(ICoordinate c0, ICoordinate c1) {
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        ICoordinate prior = null;
        for (ICoordinate next : this.envelope.getCoordinateSequence().getCoordinates()) {
            if (prior == null) {
                prior = next;
                continue;
            }
            try {
                ICoordinate coordinate = CoordinateUtilities.calculateIntersection((ICoordinate)c0, (ICoordinate)c1, (ICoordinate)prior, (ICoordinate)next);
                if (CoordinateUtilities.isInterior((ICoordinate)prior, (ICoordinate)next, (ICoordinate)coordinate)) {
                    coordinates.add(coordinate);
                }
            }
            catch (CoordinateCalculationException coordinateCalculationException) {
                // empty catch block
            }
            prior = next;
        }
        return coordinates;
    }

    protected ICoordinateSequence getInteractingCoordinateSequence(ICoordinateSequence sequence) {
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        for (ICoordinate coordinate : sequence.getCoordinates()) {
            if (!this.envelope.interact(coordinate)) continue;
            coordinates.add(coordinate);
        }
        return new CoordinateSequenceFactory().create(coordinates);
    }
}

