/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import net.anwiba.spatial.coordinate.CoordinateCalculationException;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;

public class LineIntersector {
    private ICoordinate intersection;

    public void computeIntersection(ICoordinate startPoint, ICoordinate endPoint, ICoordinate point, ICoordinate otherPoint) {
        if (CoordinateUtilities.isCrossing((ICoordinate)startPoint, (ICoordinate)endPoint, (ICoordinate)point, (ICoordinate)otherPoint)) {
            try {
                this.intersection = CoordinateUtilities.calculateIntersection((ICoordinate)startPoint, (ICoordinate)endPoint, (ICoordinate)point, (ICoordinate)otherPoint);
            }
            catch (CoordinateCalculationException exception) {
                this.intersection = null;
            }
        } else {
            this.intersection = null;
        }
    }

    public boolean hasIntersection() {
        return this.intersection != null;
    }

    public boolean isIntersection(ICoordinate point) {
        if (point == null) {
            return false;
        }
        return point.equals(this.intersection);
    }
}

