/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.geometry.ILineSegment;
import net.anwiba.spatial.geometry.operator.LineSegmentIterable;

public class LineSegmentIntersectOperator {
    private final ILineSegment segment;

    public LineSegmentIntersectOperator(ILineSegment segment) {
        this.segment = segment;
    }

    public ICoordinateSequence calculate(ICoordinateSequence ... sequences) {
        ArrayList<ICoordinate> coordinates = new ArrayList<ICoordinate>();
        for (ICoordinateSequence sequence : sequences) {
            for (ILineSegment lineSegment : new LineSegmentIterable(sequence)) {
                ICoordinate coordinate = this.calculate(lineSegment);
                if (coordinate == null) continue;
                coordinates.add(coordinate);
            }
        }
        ICoordinate[] array = coordinates.toArray(new ICoordinate[coordinates.size()]);
        final ICoordinate c0 = this.segment.getStartPoint();
        Arrays.sort(array, new Comparator<ICoordinate>(){

            @Override
            public int compare(ICoordinate c1, ICoordinate c2) {
                return Double.compare(CoordinateUtilities.calculateDistance((ICoordinate)c0, (ICoordinate)c1), CoordinateUtilities.calculateDistance((ICoordinate)c0, (ICoordinate)c2));
            }
        });
        return new CoordinateSequenceFactory().create(array);
    }

    private ICoordinate calculate(ILineSegment other) {
        try {
            ICoordinate coordinate = CoordinateUtilities.calculateIntersection((ICoordinate)this.segment.getStartPoint(), (ICoordinate)this.segment.getEndPoint(), (ICoordinate)other.getStartPoint(), (ICoordinate)other.getEndPoint());
            return CoordinateUtilities.isBetween((ICoordinate)this.segment.getStartPoint(), (ICoordinate)this.segment.getEndPoint(), (ICoordinate)coordinate, (double)0.0) ? coordinate : null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

