/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import java.util.Iterator;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.geometry.ILineSegment;
import net.anwiba.spatial.geometry.internal.LineSegment;

public class LineSegmentIterable
implements Iterable<ILineSegment> {
    private final ICoordinateSequence sequence;

    public LineSegmentIterable(ICoordinateSequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public Iterator<ILineSegment> iterator() {
        return new LineSegmentIterator(this.sequence);
    }

    public static final class LineSegmentIterator
    implements Iterator<ILineSegment> {
        private final Iterator<ICoordinate> iterator;
        private ICoordinate next;

        public LineSegmentIterator(ICoordinateSequence sequence) {
            this.iterator = sequence.getCoordinates().iterator();
            this.next = this.iterator.hasNext() ? this.iterator.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ILineSegment next() {
            ICoordinate previous = this.next;
            this.next = this.iterator.next();
            return new LineSegment(previous, this.next);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

