/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.operator;

import java.util.List;
import net.anwiba.spatial.coordinate.CoordinateUtilities;
import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.ILineSegment;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.operator.EnvelopeInteractOperator;
import net.anwiba.spatial.geometry.operator.IEnvelopeConverter;
import net.anwiba.spatial.geometry.operator.LineSegmentIterable;
import net.anwiba.spatial.geometry.operator.Rtree;

public class LineStringInteractOperator {
    private Rtree<ILineSegment> tree;
    private final ILineString baseLineString;
    private final EnvelopeInteractOperator envelopeInteractOperator;

    public LineStringInteractOperator(ILineString lineString) {
        this.baseLineString = lineString;
        IEnvelope envelope = lineString.getEnvelope();
        this.envelopeInteractOperator = new EnvelopeInteractOperator(envelope);
    }

    private Rtree<ILineSegment> createTree(ILineString lineString) {
        Rtree<ILineSegment> rTree = new Rtree<ILineSegment>(new IEnvelopeConverter<ILineSegment>(){

            @Override
            public int getDimensions() {
                return 1;
            }

            @Override
            public double getMin(int axis, ILineSegment lineSegment) {
                if (axis == 0) {
                    return Math.min(lineSegment.getStartPoint().getYValue(), lineSegment.getEndPoint().getYValue());
                }
                throw new IllegalArgumentException();
            }

            @Override
            public double getMax(int axis, ILineSegment lineSegment) {
                if (axis == 0) {
                    return Math.max(lineSegment.getStartPoint().getYValue(), lineSegment.getEndPoint().getYValue());
                }
                throw new IllegalArgumentException();
            }
        });
        LineSegmentIterable lineSegments = new LineSegmentIterable(lineString.getCoordinateSequence());
        for (ILineSegment lineSegment : lineSegments) {
            rTree.insert(lineSegment);
        }
        rTree.build();
        return rTree;
    }

    public boolean contains(IGeometry geometry) {
        for (int i = 0; i < geometry.getNumberOfCoordinates(); ++i) {
            ICoordinate coordinate = geometry.getCoordinateN(i);
            if (this.touch(coordinate)) continue;
            return false;
        }
        return true;
    }

    public boolean touch(ICoordinate coordinate) {
        if (!this.envelopeInteractOperator.interact(coordinate)) {
            return false;
        }
        List<ILineSegment> lineSegments = this.getTree().query(coordinate.getYValue());
        for (ILineSegment lineSegment : lineSegments) {
            if (!CoordinateUtilities.isBetween((ICoordinate)lineSegment.getStartPoint(), (ICoordinate)lineSegment.getEndPoint(), (ICoordinate)coordinate, (double)Double.NaN)) continue;
            return true;
        }
        return false;
    }

    public Rtree<ILineSegment> getTree() {
        if (this.tree == null) {
            this.tree = this.createTree(this.baseLineString);
        }
        return this.tree;
    }
}

