/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.spatial.geometry.IGeometryFactoryProvider;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.internal.LinearRing;
import net.anwiba.spatial.geometry.polygon.IPolygonBuilder;
import net.anwiba.spatial.geometry.polygon.PolygonConsumer;
import net.anwiba.spatial.geometry.polygon.tree.GeometryNode;
import net.anwiba.spatial.geometry.polygon.tree.GeometryRootNode;
import net.anwiba.spatial.geometry.polygon.tree.IGeometryNode;

public abstract class AbstractPolygonBuilder
implements IPolygonBuilder {
    protected final GeometryRootNode rootNode = new GeometryRootNode();
    protected final IGeometryFactoryProvider factoryProvider;

    public AbstractPolygonBuilder(IGeometryFactoryProvider factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    @Override
    public void add(ILinearRing ring) {
        this.rootNode.add(new GeometryNode(this.factoryProvider, ring));
    }

    protected void add(PolygonConsumer consumer, Iterable<IGeometryNode> geometryNodes) {
        for (IGeometryNode geometryNode : geometryNodes) {
            consumer.add(this.createPolygon(geometryNode.asLinearRing(), geometryNode.getChildren()));
            for (IGeometryNode node : geometryNode.getChildren()) {
                this.add(consumer, node.getChildren());
            }
        }
    }

    private IPolygon createPolygon(ILinearRing shell, List<IGeometryNode> children) {
        ArrayList<ILinearRing> holes = new ArrayList<ILinearRing>();
        for (IGeometryNode node : children) {
            holes.add(node.asLinearRing());
        }
        return this.factoryProvider.getGeometryFactory(shell.getCoordinateReferenceSystem()).createPolygon(shell, holes.toArray(new LinearRing[holes.size()]));
    }

    protected List<IPolygon> getPolygons() {
        PolygonConsumer consumer = new PolygonConsumer();
        this.add(consumer, this.rootNode.getChildren());
        return consumer.getPolygons();
    }
}

