/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon;

import net.anwiba.spatial.coordinate.CoordinateSequenceFactory;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.internal.GeometryFactory;
import net.anwiba.spatial.geometry.utilities.HoneycombUtilities;

public class HonycombPolygonFactory {
    private static IGeometryFactory geometryFactory;

    public HonycombPolygonFactory(ICoordinateReferenceSystem coordinateReferenceSystem) {
        geometryFactory = new GeometryFactory(coordinateReferenceSystem);
    }

    public IPolygon create(double x, double y, double radius, double buffer) {
        return this.create(HoneycombUtilities.createKey(x, y, radius), radius, buffer);
    }

    public IPolygon create(long key, double radius, double buffer) {
        double gridWidth = Math.sqrt(3.0) * radius;
        double halfWidth = gridWidth / 2.0;
        int column = HoneycombUtilities.toColumn(key);
        int row = HoneycombUtilities.toRow(key);
        double centerY = HoneycombUtilities.getCenterY(row, radius);
        double centerX = HoneycombUtilities.getCenterX(column, row, gridWidth);
        double diagonalOffsetBuffer = buffer / Math.sqrt(2.0);
        double leftX = centerX - halfWidth;
        double rightX = centerX + halfWidth;
        double upperMostY = centerY + radius;
        double upperY = centerY + radius / 2.0;
        double lowerY = centerY - radius / 2.0;
        double lowerMostY = centerY - radius;
        return geometryFactory.createPolygon(new CoordinateSequenceFactory().create(new double[]{leftX - diagonalOffsetBuffer, centerX, rightX + diagonalOffsetBuffer, rightX + diagonalOffsetBuffer, centerX, leftX - diagonalOffsetBuffer, leftX - diagonalOffsetBuffer}, new double[]{upperY + diagonalOffsetBuffer, upperMostY + buffer, upperY + diagonalOffsetBuffer, lowerY - diagonalOffsetBuffer, lowerMostY - buffer, lowerY - diagonalOffsetBuffer, upperY + diagonalOffsetBuffer}));
    }
}

