/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.polygon;

import java.util.ArrayList;
import java.util.Objects;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.spatial.coordinate.CoordinateSequenceUtilities;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.Orientation;
import net.anwiba.spatial.coordinate.calculator.CoordinateSequenceOrientationCalculator;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.IGeometryFactoryProvider;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IMultiPolygon;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.IPolygonal;
import net.anwiba.spatial.geometry.polygon.IPolygonConfiguration;

public class PolygonalToPolygonalConverter {
    private final Orientation interiorOrientation;
    private final Orientation exteriorOrientation;
    private final IGeometryFactoryProvider geometryFactoryProvider;

    public PolygonalToPolygonalConverter(IGeometryFactoryProvider geometryFactoryProvider, IPolygonConfiguration configuration) {
        this(geometryFactoryProvider, configuration.getExteriorOrientation(), configuration.getInteriorOrientation());
    }

    public PolygonalToPolygonalConverter(IGeometryFactoryProvider geometryFactoryProvider, Orientation exteriorOrientation, Orientation interiorOrientation) {
        this.geometryFactoryProvider = geometryFactoryProvider;
        this.exteriorOrientation = exteriorOrientation;
        this.interiorOrientation = interiorOrientation;
    }

    public IPolygonal convert(IPolygonal polygonal) throws ConversionException {
        if (polygonal == null) {
            return null;
        }
        IGeometryFactory geometryFactory = this.geometryFactoryProvider.getGeometryFactory(polygonal.getCoordinateReferenceSystem());
        if (polygonal instanceof IPolygon) {
            return this.convert(geometryFactory, (IPolygon)polygonal);
        }
        if (polygonal instanceof IMultiPolygon) {
            return this.convert(geometryFactory, (IMultiPolygon)polygonal);
        }
        throw new ConversionException("Unsupported implementation " + polygonal.getClass().getSimpleName());
    }

    private IMultiPolygon convert(IGeometryFactory geometryFactory, IMultiPolygon multiPolygon) {
        ArrayList<IPolygon> polygons = new ArrayList<IPolygon>(multiPolygon.getNumberOfGeometries());
        for (IPolygon polygon : multiPolygon.geometries()) {
            polygons.add(this.convert(geometryFactory, polygon));
        }
        return geometryFactory.createMultiPolygon(polygons);
    }

    private IPolygon convert(IGeometryFactory geometryFactory, IPolygon polygon) {
        ILinearRing outerRing = this.convert(geometryFactory, this.exteriorOrientation, polygon.getOuterRing());
        ArrayList<ILinearRing> innerRings = new ArrayList<ILinearRing>(polygon.getNumberOfInnerRings());
        for (ILinearRing innerRing : polygon.getInnerRings()) {
            innerRings.add(this.convert(geometryFactory, this.interiorOrientation, innerRing));
        }
        return geometryFactory.createPolygon(outerRing, innerRings);
    }

    private ILinearRing convert(IGeometryFactory geometryFactory, Orientation orientation, ILinearRing ring) {
        ICoordinateSequence coordinateSequence = ring.getCoordinateSequence();
        if (Objects.equals(orientation, CoordinateSequenceOrientationCalculator.getOrientation((ICoordinateSequence)coordinateSequence))) {
            return ring;
        }
        return geometryFactory.createLinearRing(CoordinateSequenceUtilities.reverse((ICoordinateSequence)coordinateSequence));
    }
}

