/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.utilities;

import net.anwiba.spatial.coordinate.ICoordinate;
import net.anwiba.spatial.coordinate.ICoordinateSequence;
import net.anwiba.spatial.coordinate.IEnvelope;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystem;
import net.anwiba.spatial.coordinatereferencesystem.ICoordinateReferenceSystemConstants;
import net.anwiba.spatial.geometry.IBaseGeometry;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.IGeometryFactory;
import net.anwiba.spatial.geometry.IGeometryTypeVisitor;
import net.anwiba.spatial.geometry.ILinearRing;
import net.anwiba.spatial.geometry.IPolygon;
import net.anwiba.spatial.geometry.internal.GeometryFactory;
import net.anwiba.spatial.geometry.internal.Point;

public class GeometryUtilities {
    private static final IGeometryFactory DEFAULT_GEOMETRY_FACTORY = new GeometryFactory(ICoordinateReferenceSystemConstants.NULL_COORDIANTE_REFERENCE_SYSTEM);

    public static IGeometryFactory getDefaultGeometryFactory() {
        return DEFAULT_GEOMETRY_FACTORY;
    }

    public static IGeometryFactory getGeometryFactory(ICoordinateReferenceSystem coordianteReferenceSystem) {
        return new GeometryFactory(coordianteReferenceSystem);
    }

    public static int getSrid(IGeometry geometry) {
        return geometry.getCoordinateReferenceSystem().getSrid();
    }

    public static IBaseGeometry extract(final IGeometry geometry, final int index) {
        IGeometryTypeVisitor<IBaseGeometry, RuntimeException> visitor = new IGeometryTypeVisitor<IBaseGeometry, RuntimeException>(){

            @Override
            public IBaseGeometry visitCollection() {
                return ((IGeometryCollection)geometry).getGeometryN(index);
            }

            @Override
            public IBaseGeometry visitLineString() {
                return this.createPoint(geometry.getCoordinateReferenceSystem(), geometry.getCoordinateN(index));
            }

            @Override
            public IBaseGeometry visitLinearRing() {
                return this.createPoint(geometry.getCoordinateReferenceSystem(), geometry.getCoordinateN(index));
            }

            @Override
            public IBaseGeometry visitMultiLineString() {
                return ((IGeometryCollection)geometry).getGeometryN(index);
            }

            @Override
            public IBaseGeometry visitMultiPoint() {
                return ((IGeometryCollection)geometry).getGeometryN(index);
            }

            @Override
            public IBaseGeometry visitMultiPolygon() {
                return ((IGeometryCollection)geometry).getGeometryN(index);
            }

            @Override
            public IBaseGeometry visitPoint() {
                return this.createPoint(geometry.getCoordinateReferenceSystem(), geometry.getCoordinateN(index));
            }

            private IBaseGeometry createPoint(ICoordinateReferenceSystem coordinateReferenceSystem, ICoordinate coordinate) {
                return new Point(coordinateReferenceSystem, coordinate);
            }

            @Override
            public IBaseGeometry visitPolygon() {
                if (index == 0) {
                    return ((IPolygon)geometry).getOuterRing();
                }
                return ((IPolygon)geometry).getInnerRingN(index - 1);
            }

            @Override
            public IBaseGeometry visitUnknown() {
                throw new IllegalArgumentException();
            }
        };
        return geometry.getGeometryType().accept(visitor);
    }

    public static boolean isRectangle(IPolygon polygon) {
        if (polygon.getNumberOfInnerRings() != 0) {
            return false;
        }
        ILinearRing outerRing = polygon.getOuterRing();
        if (outerRing.getNumberOfCoordinates() != 5) {
            return false;
        }
        ICoordinateSequence sequence = outerRing.getCoordinateSequence();
        IEnvelope env = polygon.getEnvelope();
        for (int i = 0; i < 5; ++i) {
            double x = sequence.getXValue(i);
            if (x != env.getMinimum().getXValue() && x != env.getMaximum().getXValue()) {
                return false;
            }
            double y = sequence.getYValue(i);
            if (y == env.getMinimum().getYValue() || y == env.getMaximum().getYValue()) continue;
            return false;
        }
        double previousX = sequence.getXValue(0);
        double previousY = sequence.getYValue(0);
        for (int i = 1; i <= 4; ++i) {
            boolean isYChanged;
            double x = sequence.getXValue(i);
            double y = sequence.getYValue(i);
            boolean isXChanged = x != previousX;
            boolean bl = isYChanged = y != previousY;
            if (isXChanged == isYChanged) {
                return false;
            }
            previousX = x;
            previousY = y;
        }
        return true;
    }
}

