/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.utilities;

import java.util.List;
import net.jafama.FastMath;

public class HoneycombUtilities {
    public static long createKey(double x, double y, double radius) {
        double gridWidth = FastMath.sqrt((double)3.0) * radius;
        double halfWidth = gridWidth / 2.0;
        double relativeX = (x - halfWidth) / gridWidth;
        double relativeY = y / radius;
        double temp = FastMath.floor((double)(relativeX + relativeY));
        int row = FastMath.floorToInt((double)((FastMath.floor((double)(relativeY - relativeX)) + temp) / 3.0));
        int column = FastMath.floorToInt((double)((FastMath.floor((double)(2.0 * relativeX + 1.0)) + temp) / 3.0)) - row;
        return HoneycombUtilities.toKey(row, column);
    }

    public static long toKey(int row, int column) {
        return (long)row << 32 | (long)column & 0xFFFFFFFFL;
    }

    public static int toColumn(long key) {
        return (int)key;
    }

    public static int toRow(long key) {
        return (int)(key >> 32);
    }

    public static List<Long> getNeighborKeys(long key) {
        int r = HoneycombUtilities.toRow(key);
        int c = HoneycombUtilities.toColumn(key);
        return List.of(Long.valueOf(HoneycombUtilities.toKey(r, c)), Long.valueOf(HoneycombUtilities.toKey(r, c + 1)), Long.valueOf(HoneycombUtilities.toKey(r, c - 1)), Long.valueOf(HoneycombUtilities.toKey(r - 1, c)), Long.valueOf(HoneycombUtilities.toKey(r + 1, c)), Long.valueOf(HoneycombUtilities.toKey(r - 1, c + 1)), Long.valueOf(HoneycombUtilities.toKey(r + 1, c - 1)));
    }

    public static long convertKey(long sourceKey, double sourceRadius, double targetRadius) {
        double gridWidth = Math.sqrt(3.0) * sourceRadius;
        int column = HoneycombUtilities.toColumn(sourceKey);
        int row = HoneycombUtilities.toRow(sourceKey);
        double centerY = HoneycombUtilities.getCenterY(row, sourceRadius);
        double centerX = HoneycombUtilities.getCenterX(column, row, gridWidth);
        return HoneycombUtilities.createKey(centerX, centerY, targetRadius);
    }

    public static double getCenterX(int column, int row, double gridWidth) {
        return (double)column * gridWidth + (double)(row + 1) * gridWidth / 2.0;
    }

    public static double getCenterY(int row, double radius) {
        return (double)row * 3.0 / 2.0 * radius + radius;
    }
}

