/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.TestGeometryFactory;
import net.anwiba.spatial.geometry.junit.GeometryAssert;
import org.junit.jupiter.api.Test;

public class GeometySerializationTest {
    @Test
    public void point() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createPoint());
    }

    @Test
    public void multiPoint() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createMultiPoint());
    }

    @Test
    public void lineString() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createLineString());
    }

    @Test
    public void multiLineString() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createMultiLineString());
    }

    @Test
    public void linearRing() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createLinearRing());
    }

    @Test
    public void polygon() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createPolygonWithHoles());
    }

    @Test
    public void multiPolygon() throws IOException, ClassNotFoundException {
        this.assertSerializable((IGeometry)TestGeometryFactory.createMultiPolygonWithHoles());
    }

    public void assertSerializable(IGeometry geometry) throws IOException, ClassNotFoundException {
        GeometryAssert.assertEquals(geometry, this.writeRead(geometry));
    }

    private <T extends Serializable> T writeRead(T object) throws IOException, ClassNotFoundException {
        byte[] array = this.write(object);
        return this.read(array);
    }

    private <T extends Serializable> byte[] write(T object) throws IOException {
        try (ByteArrayOutputStream memory = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(memory);){
                out.writeObject(object);
                byArray = memory.toByteArray();
            }
            return byArray;
        }
    }

    private <T extends Serializable> T read(byte[] array) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream memory = new ByteArrayInputStream(array);){
            Serializable serializable;
            try (ObjectInputStream in = new ObjectInputStream(memory);){
                serializable = (Serializable)in.readObject();
            }
            return (T)serializable;
        }
    }
}

