/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.spatial.geometry.extract;

import net.anwiba.spatial.geometry.IGeometry;
import net.anwiba.spatial.geometry.IGeometryCollection;
import net.anwiba.spatial.geometry.ILineString;
import net.anwiba.spatial.geometry.IPoint;
import net.anwiba.spatial.geometry.TestGeometryFactory;
import net.anwiba.spatial.geometry.extract.GeometryExtractor;
import net.anwiba.spatial.geometry.extract.GeometryReferenceFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeometryExtractorTest {
    GeometryReferenceFactory factory = new GeometryReferenceFactory();

    @Test
    public void extract_neutral() {
        IPoint geometry = TestGeometryFactory.createPoint();
        GeometryExtractor extractor = new GeometryExtractor((IGeometry)geometry);
        MatcherAssert.assertThat((Object)geometry, (Matcher)Matchers.equalTo((Object)extractor.extract(this.factory.create(new int[0]))));
    }

    @Test
    public void extract_coordinate() {
        ILineString geometry = TestGeometryFactory.createLineString();
        GeometryExtractor extractor = new GeometryExtractor((IGeometry)geometry);
        Assertions.assertEquals((Object)geometry.getCoordinateN(1), (Object)extractor.extract(this.factory.create(new int[]{1})).getCoordinateN(0));
    }

    @Test
    public void extract_basegeometry() {
        IGeometryCollection geometry = TestGeometryFactory.createGeometryCollection();
        GeometryExtractor extractor = new GeometryExtractor((IGeometry)geometry);
        MatcherAssert.assertThat((Object)geometry.getGeometryN(1), (Matcher)Matchers.sameInstance((Object)extractor.extract(this.factory.create(new int[]{1}))));
    }
}

