/*
 * Decompiled with CFR 0.152.
 */
package net.axay.fabrik.nbt.encoder;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import net.axay.fabrik.nbt.Nbt;
import net.axay.fabrik.nbt.encoder.NbtTagEncoder;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/axay/fabrik/nbt/encoder/NbtCompoundEncoder;", "Lnet/axay/fabrik/nbt/encoder/NbtTagEncoder;", "nbt", "Lnet/axay/fabrik/nbt/Nbt;", "consumer", "Lkotlin/Function1;", "Lnet/minecraft/nbt/NbtCompound;", "", "(Lnet/axay/fabrik/nbt/Nbt;Lkotlin/jvm/functions/Function1;)V", "compound", "tags", "Lkotlin/collections/ArrayDeque;", "", "consumeStructure", "element", "Lnet/minecraft/nbt/NbtElement;", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "endStructure", "popTag", "shouldEncodeElementDefault", "fabrikmc-nbt"})
public final class NbtCompoundEncoder
extends NbtTagEncoder {
    @NotNull
    private final Function1<NbtCompound, Unit> consumer;
    @NotNull
    private final NbtCompound compound;
    @NotNull
    private final ArrayDeque<String> tags;

    public NbtCompoundEncoder(@NotNull Nbt nbt, @NotNull Function1<? super NbtCompound, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        super(nbt);
        this.consumer = consumer;
        this.compound = new NbtCompound();
        this.tags = new ArrayDeque();
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.tags.add((Object)descriptor.getElementName(index));
        return true;
    }

    @Override
    public void encodeElement(@NotNull NbtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.compound.put(this.popTag(), element);
    }

    @Override
    public void consumeStructure(@NotNull NbtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.compound.put(this.popTag(), element);
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.consumer.invoke((Object)this.compound);
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.getNbt().getConfig().getEncodeDefaults();
    }

    private final String popTag() {
        return (String)this.tags.removeLast();
    }
}

