/*
 * Decompiled with CFR 0.152.
 */
package net.axay.fabrik.nbt.encoder;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import net.axay.fabrik.nbt.ConversionKt;
import net.axay.fabrik.nbt.Nbt;
import net.axay.fabrik.nbt.encoder.NbtCompoundEncoder;
import net.axay.fabrik.nbt.encoder.NbtListEncoder;
import net.axay.fabrik.nbt.internal.ListLikeSerializationKt;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtList;
import net.minecraft.nbt.NbtString;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020#H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010.\u001a\u00020\u0012H\u0016J\b\u0010/\u001a\u00020\u0012H\u0016J)\u00100\u001a\u00020\u0012\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u0006\u0010\u0016\u001a\u0002H1H\u0016\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u000208H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00069"}, d2={"Lnet/axay/fabrik/nbt/encoder/NbtTagEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "nbt", "Lnet/axay/fabrik/nbt/Nbt;", "(Lnet/axay/fabrik/nbt/Nbt;)V", "isNextNullable", "", "getNbt", "()Lnet/axay/fabrik/nbt/Nbt;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "consumeStructure", "", "element", "Lnet/minecraft/nbt/NbtElement;", "encodeBoolean", "value", "encodeByte", "", "encodeByteArray", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "encodeEnum", "enumDescriptor", "index", "", "encodeFloat", "", "encodeInt", "encodeIntArray", "", "encodeLong", "", "encodeLongArray", "", "encodeMaybeNullable", "encodeNotNullMark", "encodeNull", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeShort", "", "encodeString", "", "fabrikmc-nbt"})
public abstract class NbtTagEncoder
extends AbstractEncoder {
    @NotNull
    private final Nbt nbt;
    @NotNull
    private final SerializersModule serializersModule;
    private boolean isNextNullable;

    public NbtTagEncoder(@NotNull Nbt nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.nbt = nbt;
        this.serializersModule = this.nbt.getSerializersModule();
    }

    @NotNull
    protected final Nbt getNbt() {
        return this.nbt;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        SerializationStrategy<? super T> serializationStrategy = serializer;
        if (Intrinsics.areEqual(serializationStrategy, ListLikeSerializationKt.getByteArraySerializer())) {
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
            }
            this.encodeByteArray((byte[])value);
        } else if (Intrinsics.areEqual(serializationStrategy, ListLikeSerializationKt.getIntArraySerializer())) {
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
            }
            this.encodeIntArray((int[])value);
        } else if (Intrinsics.areEqual(serializationStrategy, ListLikeSerializationKt.getLongArraySerializer())) {
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.LongArray");
            }
            this.encodeLongArray((long[])value);
        } else {
            KSerializer<?> kSerializer = ListLikeSerializationKt.getElementSerializer(serializer);
            if (Intrinsics.areEqual(kSerializer, ListLikeSerializationKt.getByteSerializer())) {
                if (value == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<kotlin.Byte>");
                }
                this.encodeByteArray(CollectionsKt.toByteArray((Collection)((Collection)value)));
            } else if (Intrinsics.areEqual(kSerializer, ListLikeSerializationKt.getIntSerializer())) {
                if (value == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<kotlin.Int>");
                }
                this.encodeIntArray(CollectionsKt.toIntArray((Collection)((Collection)value)));
            } else if (Intrinsics.areEqual(kSerializer, ListLikeSerializationKt.getLongSerializer())) {
                if (value == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<kotlin.Long>");
                }
                this.encodeLongArray(CollectionsKt.toLongArray((Collection)((Collection)value)));
            } else {
                super.encodeSerializableValue(serializer, value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void encodeMaybeNullable(NbtElement element) {
        NbtElement nbtElement;
        NbtTagEncoder nbtTagEncoder = this;
        if (this.isNextNullable) {
            void $this$encodeMaybeNullable_u24lambda_u2d0;
            this.isNextNullable = false;
            NbtList nbtList = new NbtList();
            boolean bl = false;
            boolean bl2 = false;
            NbtList nbtList2 = nbtList;
            NbtTagEncoder nbtTagEncoder2 = nbtTagEncoder;
            boolean bl3 = false;
            $this$encodeMaybeNullable_u24lambda_u2d0.add((Object)element);
            Unit unit = Unit.INSTANCE;
            nbtTagEncoder = nbtTagEncoder2;
            nbtElement = (NbtElement)nbtList;
        } else {
            nbtElement = element;
        }
        nbtTagEncoder.encodeElement(nbtElement);
    }

    public abstract void encodeElement(@NotNull NbtElement var1);

    public abstract void consumeStructure(@NotNull NbtElement var1);

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        return Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) ? (CompositeEncoder)new NbtListEncoder(this.nbt, (Function1<? super NbtList, Unit>)((Function1)new Function1<NbtElement, Unit>((Object)this){

            public final void invoke(@NotNull NbtElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((NbtTagEncoder)((Object)this.receiver)).consumeStructure(p0);
            }
        })) : (CompositeEncoder)new NbtCompoundEncoder(this.nbt, (Function1<? super NbtCompound, Unit>)((Function1)new Function1<NbtElement, Unit>((Object)this){

            public final void invoke(@NotNull NbtElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((NbtTagEncoder)((Object)this.receiver)).consumeStructure(p0);
            }
        }));
    }

    public void encodeNotNullMark() {
        this.isNextNullable = true;
    }

    public void encodeNull() {
        this.encodeElement((NbtElement)new NbtList());
    }

    public void encodeBoolean(boolean value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeByte(byte value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeShort(short value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeInt(int value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeLong(long value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeFloat(float value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeDouble(double value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeChar(char value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        NbtString nbtString = NbtString.of((String)enumDescriptor.getElementName(index));
        Intrinsics.checkNotNullExpressionValue((Object)nbtString, (String)"of(enumDescriptor.getElementName(index))");
        this.encodeMaybeNullable((NbtElement)nbtString);
    }

    private final void encodeByteArray(byte[] value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    private final void encodeIntArray(int[] value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }

    private final void encodeLongArray(long[] value) {
        this.encodeMaybeNullable((NbtElement)ConversionKt.toNbt(value));
    }
}

