/*
 * Decompiled with CFR 0.152.
 */
package net.axay.fabrik.nbt.serialization.decoder;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import net.axay.fabrik.nbt.serialization.Nbt;
import net.axay.fabrik.nbt.serialization.UnknownKeyException;
import net.axay.fabrik.nbt.serialization.decoder.NbtTagDecoder;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/axay/fabrik/nbt/serialization/decoder/NbtCompoundDecoder;", "Lnet/axay/fabrik/nbt/serialization/decoder/NbtTagDecoder;", "nbt", "Lnet/axay/fabrik/nbt/serialization/Nbt;", "compound", "Lnet/minecraft/nbt/NbtCompound;", "(Lnet/axay/fabrik/nbt/serialization/Nbt;Lnet/minecraft/nbt/NbtCompound;)V", "element", "Lnet/minecraft/nbt/NbtElement;", "idx", "", "decodeCollectionSize", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeElementIndex", "endStructure", "", "next", "fabrikmc-nbt"})
public final class NbtCompoundDecoder
extends NbtTagDecoder {
    @NotNull
    private final NbtCompound compound;
    private NbtElement element;
    private int idx;

    public NbtCompoundDecoder(@NotNull Nbt nbt, @NotNull NbtCompound compound) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super(nbt);
        this.compound = compound;
    }

    @Override
    @NotNull
    public NbtElement next() {
        NbtElement nbtElement;
        NbtElement nbtElement2 = this.element;
        if (nbtElement2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"element");
            nbtElement = null;
        } else {
            nbtElement = nbtElement2;
        }
        return nbtElement;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        while (this.idx < descriptor.getElementsCount()) {
            NbtCompoundDecoder nbtCompoundDecoder = this;
            int n = nbtCompoundDecoder.idx;
            nbtCompoundDecoder.idx = n + 1;
            String name = descriptor.getElementName(n);
            nbtCompoundDecoder = this.compound.get(name);
            if (nbtCompoundDecoder == null) continue;
            NbtCompoundDecoder nbtCompoundDecoder2 = nbtCompoundDecoder;
            boolean bl = false;
            boolean bl2 = false;
            NbtCompoundDecoder it = nbtCompoundDecoder2;
            boolean bl3 = false;
            this.element = it;
            return this.idx - 1;
        }
        return -1;
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.compound.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public void endStructure(@NotNull SerialDescriptor descriptor) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.getNbt().getConfig().getIgnoreUnknownKeys() || descriptor.getKind() instanceof PolymorphicKind) {
            return;
        }
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)descriptor.getElementsCount());
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv;
            int n = item$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv;
            boolean bl = false;
            String string = descriptor.getElementName((int)it);
            collection.add(string);
        }
        HashSet names = (HashSet)destination$iv;
        for (String key : this.compound.getKeys()) {
            if (names.contains(key)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            throw new UnknownKeyException(key);
        }
    }
}

