package net.axay.fabrik.persistence.mixin.world;

import net.axay.fabrik.persistence.CompoundProvider;
import net.axay.fabrik.persistence.PersistentCompound;
import net.axay.fabrik.persistence.PersistentCompoundImpl;
import net.axay.fabrik.persistence.internal.CompoundPersistentState;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.concurrent.Executor;

@Mixin(class_3218.class)
public abstract class ServerWorldMixin implements CompoundProvider {
    @Unique
    private final PersistentCompound compound = new PersistentCompoundImpl();

    @Shadow public abstract class_26 getPersistentStateManager();

    @Inject(method = "<init>", at = @At("RETURN"))
    private void onInit(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> worldKey, class_2874 dimensionType, class_3949 worldGenerationProgressListener, class_2794 chunkGenerator, boolean debugWorld, long seed, List<class_5304> spawners, boolean shouldTickTime, CallbackInfo ci) {
        getPersistentStateManager().method_17924(
            nbt -> CompoundPersistentState.Companion.fromNbt(nbt, compound),
            () -> new CompoundPersistentState(compound),
            PersistentCompoundImpl.CUSTOM_DATA_KEY
        );
    }

    @NotNull
    @Override
    public PersistentCompound getCompound() {
        return compound;
    }
}
