/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import net.blackhacker.crypto.CryptoException;
import net.blackhacker.crypto.Decryptor;
import net.blackhacker.crypto.Encryptor;
import net.blackhacker.crypto.Transformation;

public abstract class Crypto
implements Encryptor,
Decryptor {
    private final Transformation transformation;
    private final Cipher cipher;
    private final SecureRandom secureRandom = new SecureRandom();
    private final Object[] parameters;

    public Crypto(Transformation transformation, Object ... parameters) throws CryptoException {
        this.transformation = transformation;
        this.parameters = parameters;
        try {
            this.cipher = Cipher.getInstance(transformation.toString());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            String msg = String.format("Couldn't generate cipher for %s : %s", transformation.getAlgorithmString(), ex.getLocalizedMessage());
            throw new CryptoException(msg, ex);
        }
    }

    public final Cipher getCipher() {
        return this.cipher;
    }

    public final SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public final Transformation getTransformation() {
        return this.transformation;
    }

    public final byte[] generateIV() {
        byte[] iv = new byte[this.transformation.getBlockSizeBytes()];
        this.secureRandom.nextBytes(iv);
        return iv;
    }

    public final byte[] generateSalt() {
        byte[] salt = new byte[this.transformation.getSaltSizeBytes()];
        this.secureRandom.nextBytes(salt);
        return salt;
    }

    public final AlgorithmParameterSpec makeParameterSpec(Object ... parameters) throws CryptoException {
        return this.transformation.makeParameterSpec(parameters);
    }

    public final KeySpec makeKeySpec(Object ... parameters) throws CryptoException {
        return this.transformation.makeKeySpec(parameters);
    }

    public final int getBlockSizeBytes() {
        return this.transformation.getBlockSizeBytes();
    }

    public boolean hasIV() {
        return this.transformation.hasIV();
    }

    public boolean isPBE() {
        return this.transformation.isPBE();
    }

    public boolean isAsymetric() {
        return this.transformation.isAsymmetric();
    }

    public Object[] getParameters() {
        return Arrays.copyOf(this.parameters, this.parameters.length);
    }

    public boolean hasParameters() {
        return this.parameters.length > 0;
    }
}

