/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto;

import net.blackhacker.crypto.CryptoException;
import net.blackhacker.crypto.PK;
import net.blackhacker.crypto.SK;
import net.blackhacker.crypto.Transformation;
import net.blackhacker.crypto.algorithm.AsymmetricAlgorithm;
import net.blackhacker.crypto.algorithm.DigestAlgorithm;
import net.blackhacker.crypto.algorithm.Mode;
import net.blackhacker.crypto.algorithm.SymmetricAlgorithm;

public final class CryptoFactory {
    public static PK newEncryptorRSAWithECB() throws CryptoException {
        return new PK(new Transformation(AsymmetricAlgorithm.RSA1024, Mode.ECB));
    }

    public static PK newEncryptorRSAWithECB(byte[] publicKeyEncoded, byte[] privateKeyEncoded) throws CryptoException {
        return new PK(new Transformation(AsymmetricAlgorithm.RSA1024, Mode.ECB), publicKeyEncoded, privateKeyEncoded);
    }

    public static PK newEncryptorRSAWithECB(byte[] publicKeyEncoded) throws CryptoException {
        return new PK(new Transformation(AsymmetricAlgorithm.RSA1024, Mode.ECB), publicKeyEncoded);
    }

    public static final SK newEncryptorDESWithECB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.ECB), new Object[0]);
    }

    public static final SK newEncryptorDESWithECB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.ECB), new Object[]{key});
    }

    public static final SK newEncryptorDESWithCBC() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.CBC), new Object[0]);
    }

    public static final SK newEncryptorDESWithCBC(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.CBC), new Object[]{key});
    }

    public static final SK newEncryptorDESWithCFB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.CFB), new Object[0]);
    }

    public static final SK newEncryptorDESWithCFB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.CFB), new Object[]{key});
    }

    public static final SK newEncryptorDESWithOFB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.OFB), new Object[0]);
    }

    public static final SK newEncryptorDESWithOFB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DES, Mode.OFB), new Object[]{key});
    }

    public static final SK newEncryptorDESedeWithECB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.ECB), new Object[0]);
    }

    public static final SK newEncryptorDESedeWithECB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.ECB), new Object[]{key});
    }

    public static final SK newEncryptorDESedeWithCBC() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.CBC), new Object[0]);
    }

    public static final SK newEncryptorDESedeWithCBC(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.CBC), new Object[]{key});
    }

    public static final SK newEncryptorDESedeWithCFB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.CFB), new Object[0]);
    }

    public static final SK newEncryptorDESedeWithCFB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.CFB), new Object[]{key});
    }

    public static final SK newEncryptorDESedeWithOFB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.OFB), new Object[0]);
    }

    public static final SK newEncryptorDESedeWithOFB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.OFB), new Object[]{key});
    }

    public static final SK newEncryptorAES128WithECB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.ECB), new Object[]{key});
    }

    public static final SK newEncryptorAES128WithECB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.ECB), new Object[0]);
    }

    public static final SK newEncryptorAES128WithCBC() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.DESede, Mode.CBC), new Object[0]);
    }

    public static final SK newEncryptorAES128WithCBC(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.CBC), new Object[]{key});
    }

    public static final SK newEncryptorAES128WithCFB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.CFB), new Object[]{key});
    }

    public static final SK newEncryptorAES128WithCFB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.CFB), new Object[0]);
    }

    public static final SK newEncryptorAES128WithOFB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.OFB), new Object[]{key});
    }

    public static final SK newEncryptorAES128WithOFB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.OFB), new Object[0]);
    }

    public static final SK newEncryptorAES128WithCTR(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.CTR), new Object[]{key});
    }

    public static final SK newEncryptorAES128WithCTR() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.CTR), new Object[0]);
    }

    public static final SK newEncryptorAES128WithOCB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.OCB), new Object[]{key});
    }

    public static final SK newEncryptorAES128WithOCB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES, Mode.OCB), new Object[0]);
    }

    public static final SK newEncryptorAES192WithECB(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES192, Mode.ECB), new Object[]{key});
    }

    public static final SK newEncryptorAES192WithECB() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES192, Mode.ECB), new Object[0]);
    }

    public static final SK newEncryptorAES192WithCBC() throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES192, Mode.ECB), new Object[0]);
    }

    public static final SK newEncryptorAES192WithCBC(byte[] key) throws CryptoException {
        return new SK(new Transformation(SymmetricAlgorithm.AES192, Mode.CBC), new Object[]{key});
    }

    public static final SK newEncryptorPBEWithSHAAnd3KeyTripleDES(String password) throws CryptoException {
        return new SK(new Transformation(DigestAlgorithm.SHA1, SymmetricAlgorithm.DESede), new Object[]{password.toCharArray()});
    }

    public static final SK newEncryptorPBEWithMD5AndTripleDES(String password) throws CryptoException {
        return new SK(new Transformation(DigestAlgorithm.MD5, SymmetricAlgorithm.DESede), new Object[]{password.toCharArray()});
    }

    public static final SK newEncryptorPBEWithMD5AndDES(String password) throws CryptoException {
        return new SK(new Transformation(DigestAlgorithm.MD5, SymmetricAlgorithm.DES), new Object[]{password.toCharArray()});
    }

    public static final SK newEncryptorPBEWithSHA256And256BitAES(String password) throws CryptoException {
        return new SK(new Transformation(DigestAlgorithm.SHA256, SymmetricAlgorithm.AES), new Object[]{password.toCharArray()});
    }

    public static final SK newEncryptorPBEWithSHA1AndDESede(String password) throws CryptoException {
        return new SK(new Transformation(DigestAlgorithm.SHA1, SymmetricAlgorithm.DESede), new Object[]{password.toCharArray()});
    }
}

