/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.blackhacker.crypto.Digester;
import net.blackhacker.crypto.DigesterException;
import net.blackhacker.crypto.Validator;
import net.blackhacker.crypto.algorithm.DigestAlgorithm;

public class DigesterBase
implements Digester {
    private final DigestAlgorithm digestAlgorithm;
    private final MessageDigest messageDigest;

    protected DigesterBase(DigestAlgorithm digestAlgorithm) throws DigesterException {
        Validator.notNull((Object)digestAlgorithm, "digestAlgorithm");
        this.digestAlgorithm = digestAlgorithm;
        try {
            this.messageDigest = MessageDigest.getInstance(digestAlgorithm.name());
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigesterException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] digest(byte[] data) {
        Validator.notNull(data, "data");
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            byte[] digest = this.messageDigest.digest(data);
            this.messageDigest.reset();
            return digest;
        }
    }
}

