/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import net.blackhacker.crypto.Crypto;
import net.blackhacker.crypto.CryptoException;
import net.blackhacker.crypto.Digester;
import net.blackhacker.crypto.DigesterFactory;
import net.blackhacker.crypto.Signer;
import net.blackhacker.crypto.SignerException;
import net.blackhacker.crypto.Transformation;
import net.blackhacker.crypto.Utils;
import net.blackhacker.crypto.Validator;
import net.blackhacker.crypto.Verifier;

public class PK
extends Crypto {
    private final PublicKey publicKey;
    private final PrivateKey privateKey;
    public static final Digester DEFAULT_DIGESTER = DigesterFactory.newDigesterMD5();

    public PK(Transformation transformation, byte[] publicKeyEncoded, byte[] privateKeyEncoded) throws CryptoException {
        super(transformation, new Object[0]);
        try {
            PrivateKey pr;
            KeyFactory kf = KeyFactory.getInstance(transformation.getAlgorithmString());
            PublicKey pu = publicKeyEncoded != null ? kf.generatePublic(transformation.makePublicKeySpec(new Object[]{publicKeyEncoded})) : null;
            PrivateKey privateKey = pr = privateKeyEncoded != null ? kf.generatePrivate(transformation.makePrivateKeySpec(new Object[]{privateKeyEncoded})) : null;
            if (pu == null && pr == null) {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance(transformation.getAlgorithmString());
                kpg.initialize(transformation.getKeySize(), this.getSecureRandom());
                KeyPair kp = kpg.generateKeyPair();
                pu = kp.getPublic();
                pr = kp.getPrivate();
            }
            this.publicKey = pu;
            this.privateKey = pr;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    public PK(Transformation transformation, byte[] publicKeyEncoded) throws CryptoException {
        this(transformation, publicKeyEncoded, (byte[])null);
    }

    public PK(Transformation transformation) throws CryptoException {
        this(transformation, (byte[])null, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] clearBytes) throws CryptoException {
        Validator.notNull(clearBytes, "clearBytes");
        Cipher cipher = this.getCipher();
        SecureRandom secureRandom = this.getSecureRandom();
        AlgorithmParameterSpec aps = null;
        byte[] iv = null;
        if (this.hasIV()) {
            iv = this.generateIV();
            aps = this.makeParameterSpec(new Object[]{iv});
        }
        try {
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                if (aps != null) {
                    cipher.init(1, (Key)this.publicKey, aps, secureRandom);
                } else {
                    cipher.init(1, (Key)this.publicKey, secureRandom);
                }
                byte[] cipherbytes = cipher.doFinal(clearBytes);
                if (iv != null) {
                    return Utils.concat(iv, cipherbytes);
                }
                return cipherbytes;
            }
        }
        catch (BadPaddingException ex) {
            return null;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | IllegalBlockSizeException ex) {
            throw new CryptoException(String.format("Could not encrypt data: %s : %s", this.getTransformation(), ex.getLocalizedMessage()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] data) throws CryptoException {
        Validator.notNull(data, "cipherBytes");
        if (this.privateKey == null) {
            throw new CryptoException("No PrivateKey defined");
        }
        Cipher cipher = this.getCipher();
        SecureRandom secureRandom = this.getSecureRandom();
        AlgorithmParameterSpec aps = null;
        byte[] iv = null;
        byte[] cipherBytes = data;
        if (this.hasIV()) {
            iv = new byte[this.getBlockSizeBytes()];
            cipherBytes = new byte[data.length - iv.length];
            Utils.split(data, iv, cipherBytes);
            aps = this.makeParameterSpec(new Object[]{iv});
        }
        try {
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                if (aps != null) {
                    cipher.init(2, (Key)this.privateKey, aps, secureRandom);
                } else {
                    cipher.init(2, (Key)this.privateKey, secureRandom);
                }
                return cipher.doFinal(cipherBytes);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new CryptoException(String.format("Could not decrypt data: %s : %s", this.getTransformation(), ex.getLocalizedMessage()), ex);
        }
    }

    public Verifier getVerifier() {
        return this.getVerifier(DEFAULT_DIGESTER);
    }

    public Verifier getVerifier(Digester digester) {
        Validator.notNull(digester, "digester");
        Cipher cipher = this.getCipher();
        return (data, signature) -> {
            IvParameterSpec aps = null;
            byte[] cipherBytes = data;
            if (this.hasIV()) {
                byte[] iv = new byte[this.getBlockSizeBytes()];
                cipherBytes = new byte[data.length - iv.length];
                Utils.split(data, iv, cipherBytes);
                aps = new IvParameterSpec(iv);
            }
            try {
                Cipher cipher2 = cipher;
                synchronized (cipher2) {
                    if (aps != null) {
                        cipher.init(2, (Key)this.publicKey, aps);
                    } else {
                        cipher.init(2, this.publicKey);
                    }
                    return Arrays.equals(cipher.doFinal(signature), digester.digest(data));
                }
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                return false;
            }
        };
    }

    public Signer getSigner() throws SignerException {
        return this.getSigner(DEFAULT_DIGESTER);
    }

    public Signer getSigner(Digester digester) throws SignerException {
        Validator.notNull(digester, "digester");
        if (this.privateKey == null) {
            throw new SignerException("No PrivateKey defined");
        }
        Cipher cipher = this.getCipher();
        return data -> {
            Validator.notNull(data, "data");
            IvParameterSpec aps = null;
            Object iv = null;
            if (this.hasIV()) {
                aps = new IvParameterSpec(this.generateIV());
            }
            byte[] digest = digester.digest(data);
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                try {
                    if (aps != null) {
                        cipher.init(1, (Key)this.privateKey, aps);
                    } else {
                        cipher.init(1, this.privateKey);
                    }
                    byte[] cipherBytes = cipher.doFinal(digest);
                    return Utils.concat(iv, cipherBytes);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
                    throw new SignerException("Could not sign data: " + ex.getLocalizedMessage(), ex);
                }
            }
        };
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final byte[] getPublicKeyEncoded() {
        return this.publicKey.getEncoded();
    }

    public final byte[] getPrivateKeyEncoded() {
        return this.privateKey == null ? null : this.privateKey.getEncoded();
    }
}

