/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import net.blackhacker.crypto.Crypto;
import net.blackhacker.crypto.CryptoException;
import net.blackhacker.crypto.Transformation;
import net.blackhacker.crypto.Utils;
import net.blackhacker.crypto.Validator;

public class SK
extends Crypto {
    private final Key key;

    protected SK(Transformation transformation, Object ... parameters) throws CryptoException {
        super(transformation, parameters);
        try {
            switch (parameters.length) {
                case 0: {
                    KeyGenerator kg = KeyGenerator.getInstance(transformation.getAlgorithmString());
                    kg.init(this.getSecureRandom());
                    this.key = kg.generateKey();
                    break;
                }
                default: {
                    KeySpec spec = this.makeKeySpec(parameters);
                    if (spec instanceof SecretKeySpec) {
                        this.key = (Key)((Object)spec);
                        break;
                    }
                    SecretKeyFactory kf = SecretKeyFactory.getInstance(transformation.getAlgorithmString());
                    this.key = kf.generateSecret(spec);
                    break;
                }
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(String.format("Couldn't generate key for %s : %s", transformation.toString(), e.getLocalizedMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] data) throws CryptoException {
        Validator.notNull(data, "data");
        Cipher cipher = this.getCipher();
        AlgorithmParameterSpec aps = null;
        byte[] iv = null;
        byte[] salt = null;
        byte[] iterationCountBytes = null;
        if (this.isPBE()) {
            salt = this.generateSalt();
            iterationCountBytes = Utils.toBytes(5000 + this.getSecureRandom().nextInt(1000));
            aps = this.makeParameterSpec(salt, Utils.toInt(iterationCountBytes));
        } else if (this.hasIV()) {
            iv = this.generateIV();
            aps = this.makeParameterSpec(new Object[]{iv});
        }
        try {
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                if (aps != null) {
                    cipher.init(1, this.key, aps, this.getSecureRandom());
                } else {
                    cipher.init(1, this.key, this.getSecureRandom());
                }
                byte[] cipherbytes = cipher.doFinal(data);
                return Utils.concat(salt, iterationCountBytes, iv, cipherbytes);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new CryptoException(String.format("Could not encrypt data: %s : %s", this.getTransformation(), ex.getLocalizedMessage()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] data) throws CryptoException {
        Validator.notNull(data, "data");
        Cipher cipher = this.getCipher();
        AlgorithmParameterSpec aps = null;
        byte[] iv = null;
        byte[] salt = null;
        byte[] iterationCountBytes = null;
        byte[] cipherBytes = data;
        if (this.isPBE()) {
            iterationCountBytes = new byte[4];
            salt = new byte[this.getTransformation().getSaltSizeBytes()];
            cipherBytes = new byte[data.length - salt.length - iterationCountBytes.length];
        } else if (this.hasIV()) {
            iv = new byte[this.getBlockSizeBytes()];
            cipherBytes = new byte[data.length - iv.length];
        }
        if (cipherBytes != data) {
            Utils.split(data, salt, iterationCountBytes, iv, cipherBytes);
        }
        if (salt != null) {
            aps = this.makeParameterSpec(salt, Utils.toInt(iterationCountBytes));
        } else if (iv != null) {
            aps = this.makeParameterSpec(new Object[]{iv});
        }
        try {
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                if (aps != null) {
                    cipher.init(2, this.key, aps, this.getSecureRandom());
                } else {
                    cipher.init(2, this.key, this.getSecureRandom());
                }
                return cipher.doFinal(cipherBytes);
            }
        }
        catch (BadPaddingException ex) {
            return null;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | IllegalBlockSizeException ex) {
            throw new CryptoException(String.format("Could not decrypt data: %s : %s", this.getTransformation(), ex.getLocalizedMessage()), ex);
        }
    }

    public Key getKey() throws CryptoException {
        return this.key;
    }

    public byte[] getKeyEncoded() {
        return this.key.getEncoded();
    }
}

