/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto;

import java.lang.reflect.InvocationTargetException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.blackhacker.crypto.CryptoException;
import net.blackhacker.crypto.Utils;
import net.blackhacker.crypto.algorithm.AsymmetricAlgorithm;
import net.blackhacker.crypto.algorithm.DigestAlgorithm;
import net.blackhacker.crypto.algorithm.Mode;
import net.blackhacker.crypto.algorithm.Padding;
import net.blackhacker.crypto.algorithm.SymmetricAlgorithm;

public class Transformation {
    private final SymmetricAlgorithm symmetricAlgorithm;
    private final AsymmetricAlgorithm asymmetricAlgorithm;
    private final DigestAlgorithm digestAlgorithm;
    private final Mode mode;
    private final Padding padding;

    private Transformation(DigestAlgorithm digestAlgorithm, SymmetricAlgorithm symmetricAlgorithm, AsymmetricAlgorithm asymmetricAlgorithm, Mode mode, Padding padding) {
        this.digestAlgorithm = digestAlgorithm;
        this.symmetricAlgorithm = symmetricAlgorithm;
        this.asymmetricAlgorithm = asymmetricAlgorithm;
        this.mode = mode;
        this.padding = padding;
    }

    public Transformation(SymmetricAlgorithm encryptionAlgorithm, Mode mode) {
        this(null, encryptionAlgorithm, null, mode, Padding.PKCS5Padding);
    }

    public Transformation(DigestAlgorithm digestAlgorithm, SymmetricAlgorithm symetricAlgorithm) {
        this(digestAlgorithm, symetricAlgorithm, null, null, null);
    }

    public Transformation(AsymmetricAlgorithm asymetricAlgorithm, Mode mode) {
        this(null, null, asymetricAlgorithm, mode, Padding.PKCS5Padding);
    }

    public Transformation(AsymmetricAlgorithm asymetricAlgorithm, Mode mode, Padding padding) {
        this(null, null, asymetricAlgorithm, mode, padding);
    }

    public int getBlockSize() {
        return this.isSymmetric() ? this.symmetricAlgorithm.getBlockSize() : this.asymmetricAlgorithm.getBlockSize();
    }

    public int getKeySize() {
        return this.isSymmetric() ? -1 : this.asymmetricAlgorithm.getKeySize();
    }

    public int getBlockSizeBytes() {
        return Utils.bitsToBytes(this.getBlockSize());
    }

    public boolean hasIV() {
        return this.mode != null && this.mode.hasIV();
    }

    public final boolean isPBE() {
        return this.digestAlgorithm != null;
    }

    public final int getSaltSizeBytes() {
        return this.digestAlgorithm.getSaltSizeBytes();
    }

    public final boolean isAsymmetric() {
        return this.asymmetricAlgorithm != null;
    }

    public final boolean isSymmetric() {
        return this.symmetricAlgorithm != null;
    }

    public final SymmetricAlgorithm getSymmetricAlgorithm() {
        return this.symmetricAlgorithm;
    }

    public final DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public KeySpec makeKeySpec(Object ... params) throws CryptoException {
        try {
            for (int copySize = params.length; copySize > 0; --copySize) {
                Object[] paramsCopy = new Object[copySize];
                System.arraycopy(params, 0, paramsCopy, 0, copySize);
                try {
                    if (this.isPBE()) {
                        return (KeySpec)PBEKeySpec.class.getConstructor(Transformation.getClasses(paramsCopy)).newInstance(paramsCopy);
                    }
                    if (!this.isSymmetric()) continue;
                    return this.symmetricAlgorithm.makeKeySpec(params);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            throw new CryptoException("This Transformation is not for a Symetric Algorithm");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new CryptoException("Couldn't build parameterspec :" + ex.getLocalizedMessage(), ex);
        }
    }

    public KeySpec makePublicKeySpec(Object ... params) throws CryptoException {
        if (this.isAsymmetric()) {
            return this.asymmetricAlgorithm.makePublicKeySpec(params);
        }
        throw new CryptoException("This Transformation is not for a Asymetric Algorithm");
    }

    public KeySpec makePrivateKeySpec(Object ... params) throws CryptoException {
        if (this.isAsymmetric()) {
            return this.asymmetricAlgorithm.makePrivateKeySpec(params);
        }
        throw new CryptoException("This Transformation is not for a Asymetric Algorithm");
    }

    public AlgorithmParameterSpec makeParameterSpec(Object ... params) throws CryptoException {
        try {
            for (int copySize = params.length; copySize > 0; --copySize) {
                try {
                    Object[] paramsCopy = new Object[copySize];
                    System.arraycopy(params, params.length - copySize, paramsCopy, 0, copySize);
                    if (this.isPBE()) {
                        return (AlgorithmParameterSpec)PBEParameterSpec.class.getConstructor(Utils.getClasses(paramsCopy)).newInstance(paramsCopy);
                    }
                    if (!this.isSymmetric()) continue;
                    return this.symmetricAlgorithm.getAlgorParamSpecClass().getConstructor(Transformation.getClasses(paramsCopy)).newInstance(paramsCopy);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new CryptoException("Couldn't build parameterspec :" + ex.getLocalizedMessage(), ex);
        }
        throw new CryptoException("Unsupported parameters");
    }

    private static Class<?>[] getClasses(Object[] objs) {
        Class[] classes = new Class[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            classes[i] = objs[i].getClass();
        }
        return classes;
    }

    public String toString() {
        if (this.isPBE()) {
            return String.format("PBEWith%sAnd%s", this.digestAlgorithm.name(), this.symmetricAlgorithm.getTransformationName());
        }
        if (this.isSymmetric()) {
            return String.format("%s/%s/%s", new Object[]{this.symmetricAlgorithm, this.mode, this.padding});
        }
        return String.format("%s/%s/%s", new Object[]{this.asymmetricAlgorithm, this.mode, this.padding});
    }

    public String getAlgorithmString() {
        if (this.isPBE()) {
            return String.format("PBEWith%sAnd%s", this.digestAlgorithm.name(), this.symmetricAlgorithm.getTransformationName());
        }
        if (this.isSymmetric()) {
            return this.symmetricAlgorithm.toString();
        }
        return this.asymmetricAlgorithm.toString();
    }
}

