/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto.algorithm;

import java.lang.reflect.InvocationTargetException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.blackhacker.crypto.CryptoException;
import net.blackhacker.crypto.Utils;
import net.blackhacker.crypto.Validator;

public enum AsymmetricAlgorithm {
    RSA1024(1024, 936, RSAPublicKeySpec.class, RSAPrivateKeySpec.class, "RSA"),
    RSA2048(2048, 1712, RSAPublicKeySpec.class, RSAPrivateKeySpec.class, "RSA");

    final int keySize;
    int blockSize;
    final String name;
    final Class<? extends KeySpec> publicKeySpecClass;
    final Class<? extends KeySpec> privateKeySpecClass;

    private AsymmetricAlgorithm(int keySize, int blockSize, Class<? extends KeySpec> publicKeySpecClass, Class<? extends KeySpec> privateKeySpecClass, String name) {
        this.keySize = keySize;
        this.blockSize = blockSize;
        this.publicKeySpecClass = publicKeySpecClass;
        this.privateKeySpecClass = privateKeySpecClass;
        this.name = name;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public KeySpec makePublicKeySpec(Object ... parameters) throws CryptoException {
        Validator.isTrue(parameters.length > 0, "Must give parameters");
        try {
            try {
                return this.publicKeySpecClass.getConstructor(Utils.getClasses(parameters)).newInstance(parameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return (KeySpec)X509EncodedKeySpec.class.getConstructor(Utils.getClasses(parameters)).newInstance(parameters);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new CryptoException("Unsupported parameters");
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new CryptoException(String.format("Couldn't create key spec :%s : %s", this.name(), ex.getLocalizedMessage()), ex);
        }
    }

    public KeySpec makePrivateKeySpec(Object ... parameters) throws CryptoException {
        Validator.isTrue(parameters.length > 0, "");
        try {
            try {
                return this.privateKeySpecClass.getConstructor(Utils.getClasses(parameters)).newInstance(parameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return (KeySpec)PKCS8EncodedKeySpec.class.getConstructor(Utils.getClasses(parameters)).newInstance(parameters);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new CryptoException("Unsupported parameters");
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new CryptoException(String.format("Couldn't create key spec :%s : %s", this.name(), ex.getLocalizedMessage()), ex);
        }
    }

    public String toString() {
        return this.name == null ? this.name() : this.name;
    }

    public Class<? extends KeySpec> getPublicKeySpecClass() {
        return this.publicKeySpecClass;
    }

    public Class<? extends KeySpec> getPrivateKeySpecClass() {
        return this.privateKeySpecClass;
    }
}

