/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto.algorithm;

import net.blackhacker.crypto.Utils;

public enum DigestAlgorithm {
    MD5(64),
    SHA1(160),
    SHA256(160),
    SHA384(160),
    SHA512(120);

    private final int saltSize;

    private DigestAlgorithm(int saltSize) {
        this.saltSize = saltSize;
    }

    public int getSaltSize() {
        return this.saltSize;
    }

    public int getSaltSizeBytes() {
        return Utils.bitsToBytes(this.saltSize);
    }
}

